/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.GraphUnionRead;

public class GraphOps {
    public static boolean containsGraph(DatasetGraph dsg, Node gn) {
        if (Quad.isDefaultGraph(gn)) {
            return true;
        }
        if (Quad.isUnionGraph(gn)) {
            return true;
        }
        return dsg.containsGraph(gn);
    }

    public static Graph getGraph(DatasetGraph dsg, Node gn) {
        if (gn == null) {
            return dsg.getDefaultGraph();
        }
        if (Quad.isDefaultGraph(gn)) {
            return dsg.getDefaultGraph();
        }
        if (Quad.isUnionGraph(gn)) {
            return GraphOps.unionGraph(dsg);
        }
        return dsg.getGraph(gn);
    }

    public static Graph unionGraph(DatasetGraph dsg) {
        List<Node> x = Iter.toList(dsg.listGraphNodes());
        return new GraphUnionRead(dsg, x);
    }

    public static void addAll(Graph g, Iterator<Triple> iter) {
        while (iter.hasNext()) {
            g.add(iter.next());
        }
        Iter.close(iter);
    }

    public static void addAll(Graph g, Iterable<Triple> iter) {
        GraphOps.addAll(g, iter.iterator());
    }

    public static void deleteAll(Graph g, Iterator<Triple> iter) {
        while (iter.hasNext()) {
            g.delete(iter.next());
        }
        Iter.close(iter);
    }

    public static void deleteAll(Graph g, Iterable<Triple> iter) {
        GraphOps.deleteAll(g, iter.iterator());
    }
}

