/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;

public class SocketNode
implements Runnable {
    Socket socket;
    LoggerRepository hierarchy;
    ObjectInputStream ois;
    static Logger logger = Logger.getLogger(SocketNode.class);

    public SocketNode(Socket socket, LoggerRepository hierarchy) {
        this.socket = socket;
        this.hierarchy = hierarchy;
        try {
            this.ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
        }
        catch (InterruptedIOException e2) {
            Thread.currentThread().interrupt();
            logger.error("Could not open ObjectInputStream to " + socket, e2);
        }
        catch (IOException e3) {
            logger.error("Could not open ObjectInputStream to " + socket, e3);
        }
        catch (RuntimeException e4) {
            logger.error("Could not open ObjectInputStream to " + socket, e4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this.ois != null) {
                while (true) {
                    LoggingEvent event = (LoggingEvent)this.ois.readObject();
                    Logger remoteLogger = this.hierarchy.getLogger(event.getLoggerName());
                    if (!event.getLevel().isGreaterOrEqual(remoteLogger.getEffectiveLevel())) continue;
                    remoteLogger.callAppenders(event);
                }
            }
        }
        catch (EOFException e2) {
            logger.info("Caught java.io.EOFException closing conneciton.");
        }
        catch (SocketException e3) {
            logger.info("Caught java.net.SocketException closing conneciton.");
        }
        catch (InterruptedIOException e4) {
            Thread.currentThread().interrupt();
            logger.info("Caught java.io.InterruptedIOException: " + e4);
            logger.info("Closing connection.");
        }
        catch (IOException e5) {
            logger.info("Caught java.io.IOException: " + e5);
            logger.info("Closing connection.");
        }
        catch (Exception e6) {
            logger.error("Unexpected exception. Closing conneciton.", e6);
        }
        finally {
            if (this.ois != null) {
                try {
                    this.ois.close();
                }
                catch (Exception e7) {
                    logger.info("Could not close connection.", e7);
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (InterruptedIOException e8) {
                    Thread.currentThread().interrupt();
                }
                catch (IOException ex) {}
            }
        }
    }
}

