/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.integer;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.rdfhdt.hdt.util.Mutable;

public class VByte {
    private VByte() {
    }

    public static void encode(OutputStream out, long value) throws IOException {
        if (value < 0L) {
            throw new IllegalArgumentException("Only can encode VByte of positive values");
        }
        while (value > 127L) {
            out.write((int)(value & 0x7FL));
            value >>>= 7;
        }
        out.write((int)(value | 0x80L));
    }

    public static long decode(InputStream in) throws IOException {
        long out = 0L;
        int shift = 0;
        long readbyte = in.read();
        if (readbyte == -1L) {
            throw new EOFException();
        }
        while ((readbyte & 0x80L) == 0L) {
            if (shift >= 50) {
                throw new IllegalArgumentException();
            }
            out |= (readbyte & 0x7FL) << shift;
            readbyte = in.read();
            if (readbyte == -1L) {
                throw new EOFException();
            }
            shift += 7;
        }
        return out |= (readbyte & 0x7FL) << shift;
    }

    public static long decode(ByteBuffer in) throws IOException {
        long out = 0L;
        int shift = 0;
        if (!in.hasRemaining()) {
            throw new EOFException();
        }
        byte readbyte = in.get();
        while ((readbyte & 0x80) == 0) {
            if (shift >= 50) {
                throw new IllegalArgumentException();
            }
            out |= (long)((readbyte & 0x7F) << shift);
            if (!in.hasRemaining()) {
                throw new EOFException();
            }
            readbyte = in.get();
            shift += 7;
        }
        return out |= (long)((readbyte & 0x7F) << shift);
    }

    public static int encode(byte[] data, int offset, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Only can encode VByte of positive values");
        }
        int i = 0;
        while (value > 127) {
            data[offset + i] = (byte)(value & 0x7F);
            ++i;
            value >>>= 7;
        }
        data[offset + i] = (byte)(value | 0x80);
        return ++i;
    }

    public static int decode(byte[] data, int offset, Mutable<Long> value) {
        long out = 0L;
        int i = 0;
        int shift = 0;
        while ((0x80 & data[offset + i]) == 0) {
            out |= (long)((data[offset + i] & 0x7F) << shift);
            ++i;
            shift += 7;
        }
        out |= (long)((data[offset + i] & 0x7F) << shift);
        value.setValue(out);
        return ++i;
    }

    public static void show(byte[] data, int len) {
        for (int i = 0; i < len; ++i) {
            System.out.print(Long.toHexString(data[i] & 0xFF) + " ");
        }
    }
}

