/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.section;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.TempDictionarySection;
import org.rdfhdt.hdt.listener.ProgressListener;

public class DictionarySectionCachePerThread
implements DictionarySectionPrivate {
    final int CACHE_ENTRIES = 128;
    private DictionarySectionPrivate child;
    private ThreadLocal<Map<CharSequence, Integer>> cacheString = new ThreadLocal<Map<CharSequence, Integer>>(){

        @Override
        protected Map<CharSequence, Integer> initialValue() {
            return new LinkedHashMap<CharSequence, Integer>(129, 0.75f, true){

                @Override
                public boolean removeEldestEntry(Map.Entry<CharSequence, Integer> eldest) {
                    return this.size() > 128;
                }
            };
        }
    };
    private ThreadLocal<Map<Integer, CharSequence>> cacheID = new ThreadLocal<Map<Integer, CharSequence>>(){

        @Override
        protected Map<Integer, CharSequence> initialValue() {
            return new LinkedHashMap<Integer, CharSequence>(129, 0.75f, true){

                @Override
                public boolean removeEldestEntry(Map.Entry<Integer, CharSequence> eldest) {
                    return this.size() > 128;
                }
            };
        }
    };

    public DictionarySectionCachePerThread(DictionarySectionPrivate child) {
        this.child = child;
    }

    @Override
    public int locate(CharSequence s) {
        Map<CharSequence, Integer> map = this.cacheString.get();
        Integer o = map.get(s);
        if (o == null) {
            o = this.child.locate(s);
            map.put(s, o);
        }
        return o;
    }

    @Override
    public CharSequence extract(int pos) {
        Map<Integer, CharSequence> map = this.cacheID.get();
        CharSequence o = map.get(pos);
        if (o == null) {
            o = this.child.extract(pos);
            map.put(pos, o);
        }
        return o;
    }

    @Override
    public long size() {
        return this.child.size();
    }

    @Override
    public int getNumberOfElements() {
        return this.child.getNumberOfElements();
    }

    @Override
    public Iterator<? extends CharSequence> getSortedEntries() {
        return this.child.getSortedEntries();
    }

    @Override
    public void save(OutputStream output, ProgressListener listener) throws IOException {
        this.child.save(output, listener);
    }

    @Override
    public void load(InputStream input, ProgressListener listener) throws IOException {
        this.child.load(input, listener);
    }

    @Override
    public void load(TempDictionarySection other, ProgressListener listener) {
        this.child.load(other, listener);
    }

    @Override
    public void close() throws IOException {
        this.cacheString = null;
        this.cacheID = null;
        this.child.close();
    }
}

