/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.NotFoundException;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTFactory;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdt.hdt.HDTPrivate;
import org.rdfhdt.hdt.hdt.TempHDT;
import org.rdfhdt.hdt.hdt.TempHDTImporter;
import org.rdfhdt.hdt.hdt.impl.HDTImpl;
import org.rdfhdt.hdt.hdt.impl.TempHDTImporterOnePass;
import org.rdfhdt.hdt.hdt.impl.TempHDTImporterTwoPass;
import org.rdfhdt.hdt.header.HeaderUtil;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.options.HDTSpecification;
import org.rdfhdt.hdt.triples.IteratorTripleString;
import org.rdfhdt.hdt.util.StopWatch;

public class HDTManagerImpl
extends HDTManager {
    @Override
    public HDTOptions doReadOptions(String file) throws IOException {
        return new HDTSpecification(file);
    }

    @Override
    public HDT doLoadHDT(String hdtFileName, ProgressListener listener) throws IOException {
        HDTImpl hdt = new HDTImpl(new HDTSpecification());
        hdt.loadFromHDT(hdtFileName, listener);
        return hdt;
    }

    @Override
    protected HDT doMapHDT(String hdtFileName, ProgressListener listener) throws IOException {
        HDTImpl hdt = new HDTImpl(new HDTSpecification());
        hdt.mapFromHDT(new File(hdtFileName), 0L, listener);
        return hdt;
    }

    @Override
    public HDT doLoadHDT(InputStream hdtFile, ProgressListener listener) throws IOException {
        HDTImpl hdt = new HDTImpl(new HDTSpecification());
        hdt.loadFromHDT(hdtFile, listener);
        return hdt;
    }

    @Override
    public HDT doLoadIndexedHDT(String hdtFileName, ProgressListener listener) throws IOException {
        HDTImpl hdt = new HDTImpl(new HDTSpecification());
        hdt.loadFromHDT(hdtFileName, listener);
        hdt.loadOrCreateIndex(listener);
        return hdt;
    }

    @Override
    protected HDT doMapIndexedHDT(String hdtFileName, ProgressListener listener) throws IOException {
        HDTImpl hdt = new HDTImpl(new HDTSpecification());
        hdt.mapFromHDT(new File(hdtFileName), 0L, listener);
        hdt.loadOrCreateIndex(listener);
        return hdt;
    }

    @Override
    public HDT doLoadIndexedHDT(InputStream hdtFile, ProgressListener listener) throws IOException {
        HDTImpl hdt = new HDTImpl(new HDTSpecification());
        hdt.loadFromHDT(hdtFile, listener);
        hdt.loadOrCreateIndex(listener);
        return hdt;
    }

    @Override
    public HDT doIndexedHDT(HDT hdt, ProgressListener listener) {
        ((HDTPrivate)hdt).loadOrCreateIndex(listener);
        return hdt;
    }

    @Override
    public HDT doGenerateHDT(String rdfFileName, String baseURI, RDFNotation rdfNotation, HDTOptions spec, ProgressListener listener) throws IOException, ParserException {
        try {
            HDTFactory.getTempFactory().checkTwoPass(spec);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String loaderType = spec.get("loader.type");
        TempHDTImporter loader = "two-pass".equals(loaderType) ? new TempHDTImporterTwoPass() : new TempHDTImporterOnePass();
        StopWatch st = new StopWatch();
        TempHDT modHdt = loader.loadFromRDF(spec, rdfFileName, baseURI, rdfNotation, listener);
        HDTImpl hdt = new HDTImpl(spec);
        hdt.loadFromModifiableHDT(modHdt, listener);
        hdt.populateHeaderStructure(modHdt.getBaseURI());
        try {
            long originalSize = HeaderUtil.getPropertyLong(modHdt.getHeader(), "_:statistics", "<http://purl.org/HDT/hdt#originalSize>");
            hdt.getHeader().insert((CharSequence)"_:statistics", (CharSequence)"<http://purl.org/HDT/hdt#originalSize>", originalSize);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        System.out.println("File converted in: " + st.stopAndShow());
        modHdt.close();
        return hdt;
    }

    @Override
    public HDT doGenerateHDT(IteratorTripleString triples, String baseURI, HDTOptions spec, ProgressListener listener) throws IOException {
        TempHDTImporterOnePass loader = new TempHDTImporterOnePass();
        StopWatch st = new StopWatch();
        TempHDT modHdt = loader.loadFromTriples(spec, triples, baseURI, listener);
        HDTImpl hdt = new HDTImpl(spec);
        hdt.loadFromModifiableHDT(modHdt, listener);
        hdt.populateHeaderStructure(modHdt.getBaseURI());
        try {
            long originalSize = HeaderUtil.getPropertyLong(modHdt.getHeader(), "_:statistics", "<http://purl.org/HDT/hdt#originalSize>");
            hdt.getHeader().insert((CharSequence)"_:statistics", (CharSequence)"<http://purl.org/HDT/hdt#originalSize>", originalSize);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        System.out.println("File converted in: " + st.stopAndShow());
        modHdt.close();
        return hdt;
    }
}

