/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.rdfhdt.hdt.iterator.utils.Filter;
import org.rdfhdt.hdt.iterator.utils.Transform;

public class Iter {
    private Iter() {
    }

    public static <T, R> Iterable<R> mapIterable(final Iterable<T> iter1, final Transform<T, R> converter) {
        return new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                return Iter.map(iter1, converter);
            }
        };
    }

    public static <T, R> Iterator<R> map(Iterable<? extends T> stream, Transform<T, R> converter) {
        return Iter.map(stream.iterator(), converter);
    }

    public static <T, R> Iterator<R> map(final Iterator<? extends T> stream, final Transform<T, R> converter) {
        Iterator iter = new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return stream.hasNext();
            }

            @Override
            public R next() {
                return converter.convert(stream.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("map.remove");
            }
        };
        return iter;
    }

    public static <T> Iterator<T> filter(Iterable<? extends T> stream, Filter<T> filter) {
        return Iter.filter(stream.iterator(), filter);
    }

    public static <T> Iterator<T> filter(final Iterator<? extends T> stream, final Filter<T> filter) {
        Iterator iter = new Iterator<T>(){
            boolean finished;
            boolean slotOccupied;
            T slot;

            @Override
            public boolean hasNext() {
                if (this.finished) {
                    return false;
                }
                while (!this.slotOccupied) {
                    if (!stream.hasNext()) {
                        this.finished = true;
                        break;
                    }
                    Object nextItem = stream.next();
                    if (!filter.accept(nextItem)) continue;
                    this.slot = nextItem;
                    this.slotOccupied = true;
                    break;
                }
                return this.slotOccupied;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    this.slotOccupied = false;
                    return this.slot;
                }
                throw new NoSuchElementException("filter.next");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("filter.remove");
            }
        };
        return iter;
    }

    public static <T> Iterator<T> limit(final Iterator<T> it, final int limit) {
        return new Iterator<T>(){
            int pos;

            @Override
            public boolean hasNext() {
                return this.pos < limit && it.hasNext();
            }

            @Override
            public T next() {
                return it.next();
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }

    public static <T> Iterator<T> empty() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

