/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf.parsers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.rdf.RDFParserFactory;

public class RDFParserRAR
implements RDFParserCallback {
    private static final String[] cmdList = new String[]{"unrar", "vb", "<RAR>"};
    private static final String[] cmdExtractFile = new String[]{"unrar", "p", "-inul", "<RAR>", "<FILE>"};
    private static Boolean available;

    public static boolean isAvailable() {
        if (available == null) {
            try {
                new ProcessBuilder(cmdList[0]).start();
                available = true;
            }
            catch (IOException e2) {
                available = false;
            }
        }
        return available;
    }

    @Override
    public void doParse(String rarFile, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        try {
            String fileName;
            String[] cmdList1 = Arrays.copyOf(cmdList, cmdList.length);
            cmdList1[2] = rarFile;
            ProcessBuilder listProcessBuilder = new ProcessBuilder(cmdList1);
            Process processList = listProcessBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(processList.getInputStream(), Charset.forName("UTF-8")));
            String[] cmdExtract = Arrays.copyOf(cmdExtractFile, cmdExtractFile.length);
            cmdExtract[3] = rarFile;
            while ((fileName = reader.readLine()) != null) {
                System.out.println("File: " + fileName);
                RDFNotation guessnot = RDFNotation.guess(fileName);
                if (guessnot != null) {
                    System.out.println("Parse from rar: " + fileName + " as " + (Object)((Object)guessnot));
                    RDFParserCallback parser = RDFParserFactory.getParserCallback(guessnot);
                    cmdExtract[4] = fileName;
                    ProcessBuilder extractProcessBuilder = new ProcessBuilder(cmdExtract);
                    Process processExtract = extractProcessBuilder.start();
                    InputStream in = processExtract.getInputStream();
                    parser.doParse(in, baseUri, guessnot, callback);
                    in.close();
                    processExtract.waitFor();
                    continue;
                }
                System.out.println("Parse from rar " + fileName + ": Not suitable parser found.");
            }
            reader.close();
            processList.waitFor();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new ParserException();
        }
    }

    @Override
    public void doParse(InputStream input, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        throw new NotImplementedException();
    }
}

