/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.triples.TripleString;
import org.rdfhdt.hdt.util.io.ExternalDecompressStream;

public class RDFParserSimple
implements RDFParserCallback {
    @Override
    public void doParse(String fileName, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        try {
            String line;
            BufferedReader reader = fileName.equals("-") ? new BufferedReader(new InputStreamReader(System.in)) : (fileName.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(fileName)))) : (fileName.endsWith(".bz2") ? new BufferedReader(new InputStreamReader(new ExternalDecompressStream(new File(fileName), ExternalDecompressStream.BZIP2))) : new BufferedReader(new FileReader(new File(fileName)))));
            long numLine = 1L;
            TripleString triple = new TripleString();
            while ((line = reader.readLine()) != null) {
                try {
                    triple.read(line);
                }
                catch (Exception e2) {
                    System.err.println("Warning: Could not parse triple at line " + numLine + ", ignored and not processed.\n Line: " + line + "\nError: " + e2.getMessage());
                }
                if (!triple.hasEmpty()) {
                    callback.processTriple(triple, 0L);
                } else {
                    System.err.println("Warning: Could not parse triple at line " + numLine + ", ignored and not processed.\n" + line);
                }
                ++numLine;
            }
            reader.close();
        }
        catch (Exception e3) {
            e3.printStackTrace();
            throw new ParserException();
        }
    }

    @Override
    public void doParse(InputStream input, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            long numLine = 1L;
            TripleString triple = new TripleString();
            while ((line = reader.readLine()) != null) {
                triple.read(line);
                if (!triple.hasEmpty()) {
                    callback.processTriple(triple, 0L);
                } else {
                    System.err.println("Warning: Could not parse triple at line " + numLine + ", ignored and not processed.\n" + line);
                }
                ++numLine;
            }
            reader.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new ParserException();
        }
    }
}

