/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples;

import java.io.IOException;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.util.UnicodeEscape;

public class TripleString {
    private CharSequence subject;
    private CharSequence predicate;
    private CharSequence object;

    public TripleString() {
        this.object = null;
        this.predicate = null;
        this.subject = null;
    }

    public TripleString(CharSequence subject, CharSequence predicate, CharSequence object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public TripleString(TripleString other) {
        this.subject = other.subject;
        this.predicate = other.predicate;
        this.object = other.object;
    }

    public CharSequence getSubject() {
        return this.subject;
    }

    public void setSubject(CharSequence subject) {
        this.subject = subject;
    }

    public CharSequence getPredicate() {
        return this.predicate;
    }

    public void setPredicate(CharSequence predicate) {
        this.predicate = predicate;
    }

    public CharSequence getObject() {
        return this.object;
    }

    public void setObject(CharSequence object) {
        this.object = object;
    }

    public void setAll(CharSequence subject, CharSequence predicate, CharSequence object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public boolean equals(TripleString other) {
        return this.subject.equals(other.subject) && this.predicate.equals(other.predicate) && this.object.equals(other.object);
    }

    public boolean match(TripleString pattern) {
        return !(pattern.getSubject() != "" && !pattern.getSubject().equals(this.subject) || pattern.getPredicate() != "" && !pattern.getPredicate().equals(this.predicate) || pattern.getObject() != "" && !pattern.getObject().equals(this.object));
    }

    public void clear() {
        this.object = "";
        this.predicate = "";
        this.subject = "";
    }

    public boolean isEmpty() {
        return this.subject.length() == 0 && this.predicate.length() == 0 && this.object.length() == 0;
    }

    public boolean hasEmpty() {
        return this.subject.length() == 0 || this.predicate.length() == 0 || this.object.length() == 0;
    }

    public void read(String line) throws ParserException {
        int split;
        this.clear();
        line = line.replaceAll("\\t", " ");
        int posa = 0;
        int posb = split = line.indexOf(32, posa);
        if (posb == -1) {
            return;
        }
        if (line.charAt(posa) == '<') {
            ++posa;
        }
        if (line.charAt(posb - 1) == '>') {
            --posb;
        }
        this.setSubject(line.substring(posa, posb));
        posa = split + 1;
        posb = split = line.indexOf(32, posa);
        if (posb == -1) {
            return;
        }
        if (line.charAt(posa) == '<') {
            ++posa;
        }
        if (posb > posa && line.charAt(posb - 1) == '>') {
            --posb;
        }
        this.setPredicate(line.substring(posa, posb));
        posa = split + 1;
        posb = line.length();
        if (line.charAt(posb - 1) == '.') {
            --posb;
        }
        if (line.charAt(posb - 1) == ' ') {
            --posb;
        }
        if (line.charAt(posa) == '<' && posb > ++posa && line.charAt(posb - 1) == '>') {
            --posb;
        }
        this.setObject(UnicodeEscape.unescapeString(line.substring(posa, posb)));
    }

    public String toString() {
        return this.subject + " " + this.predicate + " " + this.object;
    }

    public CharSequence asNtriple() throws IOException {
        StringBuilder str2 = new StringBuilder();
        this.dumpNtriple(str2);
        return str2;
    }

    public final void dumpNtriple(Appendable out) throws IOException {
        char s0 = this.subject.charAt(0);
        if (s0 == '_' || s0 == '<') {
            out.append(this.subject);
        } else {
            out.append('<').append(this.subject).append('>');
        }
        char p0 = this.predicate.charAt(0);
        if (p0 == '<') {
            out.append(' ').append(this.predicate).append(' ');
        } else {
            out.append(" <").append(this.predicate).append("> ");
        }
        char o0 = this.object.charAt(0);
        if (o0 == '\"') {
            UnicodeEscape.escapeString(this.object.toString(), out);
            out.append(" .\n");
        } else if (o0 == '_' || o0 == '<') {
            out.append(this.object).append(" .\n");
        } else {
            out.append('<').append(this.object).append("> .\n");
        }
    }
}

