/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples.impl;

import org.rdfhdt.hdt.compact.bitmap.AdjacencyList;
import org.rdfhdt.hdt.enums.ResultEstimationType;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.exceptions.NotFoundException;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.impl.BitmapTriples;
import org.rdfhdt.hdt.triples.impl.TripleOrderConvert;

public class BitmapTriplesIterator
implements IteratorTripleID {
    private BitmapTriples triples;
    private TripleID pattern;
    private TripleID returnTriple;
    private int patX;
    private int patY;
    private int patZ;
    private AdjacencyList adjY;
    private AdjacencyList adjZ;
    long posY;
    long posZ;
    long minY;
    long minZ;
    long maxY;
    long maxZ;
    private long nextY;
    private long nextZ;
    private int x;
    private int y;
    private int z;

    BitmapTriplesIterator(BitmapTriples triples, TripleID pattern) {
        this.triples = triples;
        this.returnTriple = new TripleID();
        this.pattern = new TripleID();
        this.newSearch(pattern);
    }

    public void newSearch(TripleID pattern) {
        this.pattern.assign(pattern);
        TripleOrderConvert.swapComponentOrder(this.pattern, TripleComponentOrder.SPO, this.triples.order);
        this.patX = this.pattern.getSubject();
        this.patY = this.pattern.getPredicate();
        this.patZ = this.pattern.getObject();
        this.adjY = this.triples.adjY;
        this.adjZ = this.triples.adjZ;
        this.findRange();
        this.goToStart();
    }

    private void updateOutput() {
        this.returnTriple.setAll(this.x, this.y, this.z);
        TripleOrderConvert.swapComponentOrder(this.returnTriple, this.triples.order, TripleComponentOrder.SPO);
    }

    private void findRange() {
        if (this.patX != 0) {
            block7: {
                if (this.patY != 0) {
                    try {
                        this.minY = this.adjY.find(this.patX - 1, this.patY);
                        this.maxY = this.minY + 1L;
                        if (this.patZ != 0) {
                            this.minZ = this.adjZ.find(this.minY, this.patZ);
                            this.maxZ = this.minZ + 1L;
                            break block7;
                        }
                        this.minZ = this.adjZ.find(this.minY);
                        this.maxZ = this.adjZ.last(this.minY) + 1L;
                    }
                    catch (NotFoundException e2) {
                        this.maxZ = 0L;
                        this.maxY = 0L;
                        this.minZ = 0L;
                        this.minY = 0L;
                    }
                } else {
                    this.minY = this.adjY.find(this.patX - 1);
                    this.minZ = this.adjZ.find(this.minY);
                    this.maxY = this.adjY.last(this.patX - 1) + 1L;
                    this.maxZ = this.adjZ.find(this.maxY);
                }
            }
            this.x = this.patX;
        } else {
            this.minY = 0L;
            this.minZ = 0L;
            this.maxY = this.adjY.getNumberOfElements();
            this.maxZ = this.adjZ.getNumberOfElements();
        }
    }

    @Override
    public boolean hasNext() {
        return this.posZ < this.maxZ;
    }

    @Override
    public TripleID next() {
        this.z = (int)this.adjZ.get(this.posZ);
        if (this.posZ == this.nextZ) {
            ++this.posY;
            this.y = (int)this.adjY.get(this.posY);
            this.nextZ = this.adjZ.findNext(this.nextZ) + 1L;
            if (this.posY == this.nextY) {
                ++this.x;
                this.nextY = this.adjY.findNext(this.nextY) + 1L;
            }
        }
        ++this.posZ;
        this.updateOutput();
        return this.returnTriple;
    }

    @Override
    public boolean hasPrevious() {
        return this.posZ > this.minZ;
    }

    @Override
    public TripleID previous() {
        --this.posZ;
        this.posY = this.adjZ.findListIndex(this.posZ);
        this.z = (int)this.adjZ.get(this.posZ);
        this.y = (int)this.adjY.get(this.posY);
        this.x = (int)this.adjY.findListIndex(this.posY) + 1;
        this.nextY = this.adjY.last(this.x - 1) + 1L;
        this.nextZ = this.adjZ.last(this.posY) + 1L;
        this.updateOutput();
        return this.returnTriple;
    }

    @Override
    public void goToStart() {
        this.posZ = this.minZ;
        this.posY = this.adjZ.findListIndex(this.posZ);
        this.z = (int)this.adjZ.get(this.posZ);
        this.y = (int)this.adjY.get(this.posY);
        this.x = (int)this.adjY.findListIndex(this.posY) + 1;
        this.nextY = this.adjY.last(this.x - 1) + 1L;
        this.nextZ = this.adjZ.last(this.posY) + 1L;
    }

    @Override
    public long estimatedNumResults() {
        return this.maxZ - this.minZ;
    }

    @Override
    public ResultEstimationType numResultEstimation() {
        if (this.patX != 0 && this.patY == 0 && this.patZ != 0) {
            return ResultEstimationType.UP_TO;
        }
        return ResultEstimationType.EXACT;
    }

    @Override
    public boolean canGoTo() {
        return this.pattern.isEmpty();
    }

    @Override
    public void goTo(long pos) {
        if (!this.canGoTo()) {
            throw new IllegalAccessError("Cannot goto on this bitmaptriples pattern");
        }
        if (pos >= this.adjZ.getNumberOfElements()) {
            throw new ArrayIndexOutOfBoundsException("Cannot goTo beyond last triple");
        }
        this.posZ = pos;
        this.posY = this.adjZ.findListIndex(this.posZ);
        this.z = (int)this.adjZ.get(this.posZ);
        this.y = (int)this.adjY.get(this.posY);
        this.x = (int)this.adjY.findListIndex(this.posY) + 1;
        this.nextY = this.adjY.last(this.x - 1) + 1L;
        this.nextZ = this.adjZ.last(this.posY) + 1L;
    }

    @Override
    public TripleComponentOrder getOrder() {
        return this.triples.order;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

