/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples.impl;

import org.rdfhdt.hdt.compact.bitmap.AdjacencyList;
import org.rdfhdt.hdt.enums.ResultEstimationType;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.impl.BitmapTriples;
import org.rdfhdt.hdt.triples.impl.TripleOrderConvert;

public class BitmapTriplesIteratorZ
implements IteratorTripleID {
    private BitmapTriples triples;
    private TripleID pattern;
    private TripleID returnTriple;
    private int patZ;
    private AdjacencyList adjY;
    private AdjacencyList adjZ;
    long posZ;
    private int x;
    private int y;
    private int z;

    BitmapTriplesIteratorZ(BitmapTriples triples, TripleID pattern) {
        this.triples = triples;
        this.pattern = new TripleID(pattern);
        this.returnTriple = new TripleID();
        TripleOrderConvert.swapComponentOrder(this.pattern, TripleComponentOrder.SPO, triples.order);
        this.patZ = this.pattern.getObject();
        if (this.patZ == 0) {
            throw new IllegalArgumentException("This structure is not meant to process this pattern");
        }
        this.adjY = triples.adjY;
        this.adjZ = triples.adjZ;
        this.goToStart();
    }

    private void updateOutput() {
        this.returnTriple.setAll(this.x, this.y, this.z);
        TripleOrderConvert.swapComponentOrder(this.returnTriple, this.triples.order, TripleComponentOrder.SPO);
    }

    @Override
    public boolean hasNext() {
        return this.posZ != -1L;
    }

    @Override
    public TripleID next() {
        long posY = this.adjZ.findListIndex(this.posZ);
        this.z = (int)this.adjZ.get(this.posZ);
        this.y = (int)this.adjY.get(posY);
        this.x = (int)this.adjY.findListIndex(posY) + 1;
        this.posZ = this.adjZ.findNextAppearance(this.posZ + 1L, this.patZ);
        this.updateOutput();
        return this.returnTriple;
    }

    @Override
    public boolean hasPrevious() {
        throw new NotImplementedException();
    }

    @Override
    public TripleID previous() {
        throw new NotImplementedException();
    }

    @Override
    public void goToStart() {
        this.posZ = this.adjZ.findNextAppearance(0L, this.patZ);
    }

    @Override
    public long estimatedNumResults() {
        return this.adjZ.getNumberOfElements();
    }

    @Override
    public ResultEstimationType numResultEstimation() {
        return ResultEstimationType.UNKNOWN;
    }

    @Override
    public boolean canGoTo() {
        return false;
    }

    @Override
    public void goTo(long pos) {
        if (!this.canGoTo()) {
            throw new IllegalAccessError("Cannot goto on this bitmaptriples pattern");
        }
    }

    @Override
    public TripleComponentOrder getOrder() {
        return this.triples.order;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

