/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.string;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.util.string.ByteStringUtil;
import org.rdfhdt.hdt.util.string.CharSequenceComparator;
import org.rdfhdt.hdt.util.string.CompactString;
import org.rdfhdt.hdt.util.string.DelayedString;

public final class ReplazableString
implements CharSequence,
Comparable<ReplazableString> {
    byte[] buffer;
    int used;
    private static final int READ_AHEAD = 1024;

    public ReplazableString() {
        this.buffer = new byte[16384];
        this.used = 0;
    }

    private ReplazableString(byte[] buffer) {
        this.buffer = buffer;
        this.used = buffer.length;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    private void ensureSize(int size) {
        if (size > this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, size);
        }
    }

    public void append(byte[] data, int offset, int len) {
        this.replace(this.used, data, offset, len);
    }

    public void append(CharSequence other) {
        this.ensureSize(this.used + other.length());
        for (int i = 0; i < other.length(); ++i) {
            this.buffer[this.used + i] = (byte)other.charAt(i);
        }
        this.used += other.length();
    }

    public void replace(int pos, byte[] data, int offset, int len) {
        this.ensureSize(pos + len);
        System.arraycopy(data, offset, this.buffer, pos, len);
        this.used = pos + len;
    }

    public void replace(InputStream in, int pos, int len) throws IOException {
        this.ensureSize(pos + len);
        in.read(this.buffer, pos, len);
        this.used = pos + len;
    }

    public void replace(ByteBuffer in, int pos, int len) throws IOException {
        this.ensureSize(pos + len);
        in.get(this.buffer, pos, len);
        this.used = pos + len;
    }

    public void replace2(InputStream in, int pos) throws IOException {
        this.used = pos;
        while (true) {
            int value;
            if ((value = in.read()) == -1) {
                throw new IllegalArgumentException("Was reading a string but stream ended before finding the null terminator");
            }
            if (value == 0) break;
            if (this.used >= this.buffer.length) {
                this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2);
            }
            this.buffer[this.used++] = (byte)(value & 0xFF);
        }
    }

    public void replace(InputStream in, int pos) throws IOException {
        if (!in.markSupported()) {
            this.replace2(in, pos);
            return;
        }
        this.used = pos;
        while (true) {
            if (this.used + 1024 > this.buffer.length) {
                this.buffer = Arrays.copyOf(this.buffer, Math.max(this.buffer.length * 2, this.used + 1024));
            }
            in.mark(1024);
            int numread = in.read(this.buffer, this.used, 1024);
            if (numread == -1) {
                throw new IllegalArgumentException("Was reading a string but stream ended before finding the null terminator");
            }
            for (int i = 0; i < numread; ++i) {
                if (this.buffer[this.used + i] != 0) continue;
                in.reset();
                in.skip(i + 1);
                this.used += i;
                return;
            }
            this.used += numread;
        }
    }

    public void replace(ByteBuffer in, int pos) throws IOException {
        this.used = pos;
        int n = in.capacity() - in.position();
        while (n-- != 0) {
            byte value = in.get();
            if (value == 0) {
                return;
            }
            if (this.used >= this.buffer.length) {
                this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2);
            }
            this.buffer[this.used++] = value;
        }
        throw new IllegalArgumentException("Was reading a string but stream ended before finding the null terminator");
    }

    @Override
    public char charAt(int index) {
        return (char)this.buffer[index];
    }

    @Override
    public int length() {
        return this.used;
    }

    public int hashCode() {
        int hash = -2128831035;
        int i = this.used;
        while (i-- != 0) {
            hash = hash * 16777619 ^ this.buffer[i];
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof CompactString) {
            CompactString cmp = (CompactString)o;
            if (this.buffer.length != cmp.data.length) {
                return false;
            }
            int i = this.buffer.length;
            while (i-- != 0) {
                if (this.buffer[i] == cmp.data[i]) continue;
                return false;
            }
            return true;
        }
        if (o instanceof ReplazableString) {
            ReplazableString cmp = (ReplazableString)o;
            if (this.used != cmp.used) {
                return false;
            }
            int i = this.used;
            while (i-- != 0) {
                if (this.buffer[i] == cmp.buffer[i]) continue;
                return false;
            }
            return true;
        }
        if (o instanceof CharSequence) {
            CharSequence other = (CharSequence)o;
            return this.length() == other.length() && CharSequenceComparator.getInstance().compare(this, other) == 0;
        }
        throw new NotImplementedException();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || end > this.length() || end - start < 0) {
            throw new IllegalArgumentException("Illegal range " + start + "-" + end + " for sequence of length " + this.length());
        }
        byte[] newdata = new byte[end - start];
        System.arraycopy(this.buffer, start, newdata, 0, end - start);
        return new ReplazableString(newdata);
    }

    @Override
    public String toString() {
        return new String(this.buffer, 0, this.used, ByteStringUtil.STRING_ENCODING);
    }

    @Override
    public int compareTo(ReplazableString other) {
        int n = Math.min(this.used, other.used);
        for (int k = 0; k < n; ++k) {
            int c1 = this.buffer[k] & 0xFF;
            int c2 = other.buffer[k] & 0xFF;
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return this.used - other.used;
    }

    public CharSequence getDelayed() {
        return new DelayedString(this);
    }
}

