/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena;

import java.util.Map;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.impl.RDFLangString;
import org.apache.jena.graph.JenaNodeCreator;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdtjena.bindings.HDTId;
import org.rdfhdt.hdtjena.cache.DictionaryCache;
import org.rdfhdt.hdtjena.cache.DictionaryCacheArray;
import org.rdfhdt.hdtjena.cache.DictionaryCacheLRI;
import org.rdfhdt.hdtjena.cache.DummyMap;

public class NodeDictionary {
    private final Dictionary dictionary;
    private final DictionaryCache[] cacheIDtoNode = new DictionaryCache[TripleComponentRole.values().length];
    Map<String, Integer>[] cacheNodeToId = new Map[TripleComponentRole.values().length];

    public NodeDictionary(Dictionary dictionary) {
        this.dictionary = dictionary;
        int idToNodeSize = 20000;
        this.cacheIDtoNode[0] = dictionary.getNsubjects() > 20000L ? new DictionaryCacheLRI(20000) : new DictionaryCacheArray((int)dictionary.getNsubjects());
        this.cacheIDtoNode[1] = dictionary.getNpredicates() > 20000L ? new DictionaryCacheLRI(20000) : new DictionaryCacheArray((int)dictionary.getNpredicates());
        this.cacheIDtoNode[2] = dictionary.getNobjects() > 20000L ? new DictionaryCacheLRI(20000) : new DictionaryCacheArray((int)dictionary.getNobjects());
        this.cacheNodeToId[0] = new DummyMap<String, Integer>();
        this.cacheNodeToId[1] = new DummyMap<String, Integer>();
        this.cacheNodeToId[2] = new DummyMap<String, Integer>();
    }

    public Node getNode(HDTId hdtid) {
        return this.getNode(hdtid.getId(), hdtid.getRole());
    }

    public Node getNode(int id, TripleComponentRole role) {
        Node node = this.cacheIDtoNode[role.ordinal()].get(id);
        if (node == null) {
            CharSequence str2 = this.dictionary.idToString(id, role);
            char firstChar = str2.charAt(0);
            node = firstChar == '_' ? JenaNodeCreator.createAnon(str2) : (firstChar == '\"' ? JenaNodeCreator.createLiteral(str2) : JenaNodeCreator.createURI(str2));
            this.cacheIDtoNode[role.ordinal()].put(id, node);
        }
        return node;
    }

    public int getIntID(Node node, TripleComponentRole role) {
        return this.getIntID(NodeDictionary.nodeToStr(node), role);
    }

    public int getIntID(Node node, PrefixMapping map, TripleComponentRole role) {
        return this.getIntID(NodeDictionary.nodeToStr(node, map), role);
    }

    public int getIntID(String str2, TripleComponentRole role) {
        Integer intValue = this.cacheNodeToId[role.ordinal()].get(str2);
        if (intValue != null) {
            return intValue;
        }
        int val = this.dictionary.stringToId(str2, role);
        this.cacheNodeToId[role.ordinal()].put(str2, val);
        return val;
    }

    public static String nodeToStr(Node node, PrefixMapping map) {
        if (node.isURI()) {
            return map.expandPrefix(node.getURI());
        }
        return NodeDictionary.nodeToStr(node);
    }

    public static String nodeToStr(Node node) {
        if (node == null || node.isVariable()) {
            return "";
        }
        if (node.isURI()) {
            return node.getURI();
        }
        if (node.isLiteral()) {
            RDFDatatype t = node.getLiteralDatatype();
            if (t == null || XSDDatatype.XSDstring.getURI().equals(t.getURI())) {
                return "\"" + node.getLiteralLexicalForm() + "\"";
            }
            if (RDFLangString.rdfLangString.equals(t)) {
                return "\"" + node.getLiteralLexicalForm() + "\"@" + node.getLiteralLanguage();
            }
            return "\"" + node.getLiteralLexicalForm() + "\"^^<" + t.getURI() + ">";
        }
        return node.toString();
    }

    public TripleID getTripleID(Triple triple, PrefixMapping map) {
        return new TripleID(this.getIntID(NodeDictionary.nodeToStr(triple.getSubject(), map), TripleComponentRole.SUBJECT), this.getIntID(NodeDictionary.nodeToStr(triple.getPredicate(), map), TripleComponentRole.PREDICATE), this.getIntID(NodeDictionary.nodeToStr(triple.getObject(), map), TripleComponentRole.OBJECT));
    }

    public TripleID getTriplePatID(Triple jenaTriple) {
        int subject = 0;
        int predicate = 0;
        int object = 0;
        if (jenaTriple.getMatchSubject() != null) {
            subject = this.getIntID(jenaTriple.getMatchSubject(), TripleComponentRole.SUBJECT);
        }
        if (jenaTriple.getMatchPredicate() != null) {
            predicate = this.getIntID(jenaTriple.getMatchPredicate(), TripleComponentRole.PREDICATE);
        }
        if (jenaTriple.getMatchObject() != null) {
            object = this.getIntID(jenaTriple.getMatchObject(), TripleComponentRole.OBJECT);
        }
        return new TripleID(subject, predicate, object);
    }

    public static PrefixMapping getMapping(ExecutionContext ctx) {
        Query query2 = (Query)ctx.getContext().get(ARQConstants.sysCurrentQuery);
        return query2.getPrefixMapping();
    }

    public static final Var asVar(Node node) {
        if (Var.isVar(node)) {
            return Var.alloc(node);
        }
        return null;
    }

    public static int translate(NodeDictionary dictionary, HDTId id, TripleComponentRole role) {
        if (dictionary == id.getDictionary()) {
            return id.getValue();
        }
        NodeDictionary dict2 = id.getDictionary();
        CharSequence str2 = dict2.dictionary.idToString(id.getValue(), id.getRole());
        return dictionary.getIntID(str2.toString(), role);
    }
}

