/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena.cmd;

import java.io.OutputStream;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdtjena.HDTGraph;

public class HDTSparql {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        if (args.length != 2) {
            System.err.println("Usage: hdtsparql <hdt input> <SPARQL Query>.");
            System.exit(1);
        }
        String fileHDT = args[0];
        String sparqlQuery = args[1];
        HDT hdt = HDTManager.mapIndexedHDT(fileHDT, null);
        try {
            HDTGraph graph = new HDTGraph(hdt);
            Model model = ModelFactory.createModelForGraph(graph);
            Query query2 = QueryFactory.create(sparqlQuery);
            QueryExecution qe = QueryExecutionFactory.create(query2, model);
            try {
                ResultSet results = qe.execSelect();
                ResultSetFormatter.outputAsCSV((OutputStream)System.out, results);
            }
            finally {
                qe.close();
            }
        }
        finally {
            hdt.close();
        }
    }
}

