/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena.solver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Tuple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdtjena.HDTGraph;
import org.rdfhdt.hdtjena.NodeDictionary;
import org.rdfhdt.hdtjena.bindings.BindingHDTId;
import org.rdfhdt.hdtjena.bindings.BindingHDTNode;
import org.rdfhdt.hdtjena.bindings.HDTId;
import org.rdfhdt.hdtjena.solver.QueryIterHDT;
import org.rdfhdt.hdtjena.solver.StageMatchTripleID;
import org.rdfhdt.hdtjena.util.Abortable;
import org.rdfhdt.hdtjena.util.IterAbortable;
import org.rdfhdt.hdtjena.util.VarAppearance;

public class HDTSolverLib {
    public static long numBGPs;
    public static final ConvertHDTIdToNode converter;

    protected static QueryIterator execute(HDTGraph graph, BasicPattern pattern, QueryIterator input, Predicate<Tuple<HDTId>> filter, ExecutionContext execCxt) {
        ++numBGPs;
        Iterator<BindingHDTId> chain = Iter.map(input, HDTSolverLib.convFromBinding(graph.getNodeDictionary(), execCxt));
        ArrayList<Abortable> killList = new ArrayList<Abortable>();
        HashMap<Var, VarAppearance> mapVar = new HashMap<Var, VarAppearance>();
        for (Triple triplePattern : pattern) {
            HDTSolverLib.addVarAppearance(mapVar, triplePattern.getSubject(), TripleComponentRole.SUBJECT);
            HDTSolverLib.addVarAppearance(mapVar, triplePattern.getObject(), TripleComponentRole.OBJECT);
        }
        for (Triple triplePattern : pattern) {
            chain = HDTSolverLib.solve(graph, triplePattern, chain, filter, mapVar, execCxt);
            chain = IterAbortable.makeAbortable(chain, killList);
        }
        Iterator<Binding> iterBinding = converter.convert(graph.getNodeDictionary(), chain);
        return new QueryIterHDT(iterBinding, killList, input, execCxt);
    }

    private static void addVarAppearance(Map<Var, VarAppearance> mapVar, Node node, TripleComponentRole role) {
        if (node.isVariable()) {
            Var v = NodeDictionary.asVar(node);
            VarAppearance varAp = mapVar.get(v);
            if (varAp == null) {
                varAp = new VarAppearance();
                mapVar.put(v, varAp);
            }
            varAp.set(role);
        }
    }

    private static Iterator<BindingHDTId> solve(HDTGraph graph, Triple tuple, Iterator<BindingHDTId> chain, Predicate<Tuple<HDTId>> filter, Map<Var, VarAppearance> mapVar, ExecutionContext execCxt) {
        return new StageMatchTripleID(graph, chain, tuple, execCxt, mapVar);
    }

    private static HDTId getID(Node n, NodeDictionary dict, PrefixMapping prefixMapping) {
        int id = dict.getIntID(n, prefixMapping, TripleComponentRole.SUBJECT);
        if (id > 0) {
            return new HDTId(id, TripleComponentRole.SUBJECT, dict);
        }
        id = dict.getIntID(n, prefixMapping, TripleComponentRole.PREDICATE);
        if (id > 0) {
            return new HDTId(id, TripleComponentRole.PREDICATE, dict);
        }
        id = dict.getIntID(n, prefixMapping, TripleComponentRole.OBJECT);
        if (id > 0) {
            return new HDTId(id, TripleComponentRole.OBJECT, dict);
        }
        return null;
    }

    private static Function<BindingHDTId, Binding> convToBinding(NodeDictionary dictionary) {
        return new Function<BindingHDTId, Binding>(){

            @Override
            public Binding apply(BindingHDTId bindingIds) {
                return new BindingHDTNode(bindingIds);
            }
        };
    }

    public static Iterator<BindingHDTId> convertToIds(Iterator<Binding> iterBindings, NodeDictionary dictionary, ExecutionContext ctx) {
        return Iter.map(iterBindings, HDTSolverLib.convFromBinding(dictionary, ctx));
    }

    public static Iterator<Binding> convertToNodes(Iterator<BindingHDTId> iterBindingIds, NodeDictionary dictionary) {
        return Iter.map(iterBindingIds, HDTSolverLib.convToBinding(dictionary));
    }

    public static Function<Binding, BindingHDTId> convFromBinding(final NodeDictionary dictionary, final ExecutionContext ctx) {
        return new Function<Binding, BindingHDTId>(){
            PrefixMapping mapping;
            {
                this.mapping = NodeDictionary.getMapping(ctx);
            }

            @Override
            public BindingHDTId apply(Binding binding) {
                if (binding instanceof BindingHDTNode) {
                    return ((BindingHDTNode)binding).getBindingId();
                }
                BindingHDTId b = new BindingHDTId(binding);
                Iterator<Var> vars = binding.vars();
                while (vars.hasNext()) {
                    Var v = vars.next();
                    Node n = binding.get(v);
                    if (n == null) continue;
                    HDTId id = HDTSolverLib.getID(n, dictionary, this.mapping);
                    b.put(v, id);
                }
                return b;
            }
        };
    }

    static {
        converter = new ConvertHDTIdToNode(){

            @Override
            public Iterator<Binding> convert(NodeDictionary dictionary, Iterator<BindingHDTId> iterBindingIds) {
                return Iter.map(iterBindingIds, HDTSolverLib.convToBinding(dictionary));
            }
        };
    }

    public static interface ConvertHDTIdToNode {
        public Iterator<Binding> convert(NodeDictionary var1, Iterator<BindingHDTId> var2);
    }
}

