/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena.solver;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.RepeatApplyIterator;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.Triples;
import org.rdfhdt.hdtjena.HDTGraph;
import org.rdfhdt.hdtjena.NodeDictionary;
import org.rdfhdt.hdtjena.bindings.BindingHDTId;
import org.rdfhdt.hdtjena.bindings.HDTId;
import org.rdfhdt.hdtjena.util.VarAppearance;

public class StageMatchTripleID
extends RepeatApplyIterator<BindingHDTId> {
    public static long numSearches;
    private final NodeDictionary dictionary;
    private final Triples triples;
    private final TripleID patternID;
    private final PrefixMapping prefixMap;
    private final Var[] var = new Var[3];
    private final boolean[] varIsSO = new boolean[3];
    private final long numSharedSO;

    public StageMatchTripleID(HDTGraph graph, Iterator<BindingHDTId> input, Triple patternTuple, ExecutionContext execCxt, Map<Var, VarAppearance> mapVar) {
        super(input);
        this.dictionary = graph.getNodeDictionary();
        this.triples = graph.getHDT().getTriples();
        this.prefixMap = NodeDictionary.getMapping(execCxt);
        this.numSharedSO = graph.getHDT().getDictionary().getNshared();
        int subject = 0;
        int predicate = 0;
        int object = 0;
        Node subjectNode = patternTuple.getSubject();
        if (!subjectNode.isVariable()) {
            subject = this.dictionary.getIntID(subjectNode, this.prefixMap, TripleComponentRole.SUBJECT);
        } else {
            this.var[0] = NodeDictionary.asVar(subjectNode);
            this.varIsSO[0] = mapVar.get(this.var[0]).isSubjectObject();
        }
        Node predicateNode = patternTuple.getPredicate();
        if (!predicateNode.isVariable()) {
            predicate = this.dictionary.getIntID(predicateNode, this.prefixMap, TripleComponentRole.PREDICATE);
        } else {
            this.var[1] = NodeDictionary.asVar(predicateNode);
        }
        Node objectNode = patternTuple.getObject();
        if (!objectNode.isVariable()) {
            object = this.dictionary.getIntID(objectNode, this.prefixMap, TripleComponentRole.OBJECT);
        } else {
            this.var[2] = NodeDictionary.asVar(objectNode);
            this.varIsSO[2] = mapVar.get(this.var[2]).isSubjectObject();
        }
        this.patternID = new TripleID(subject, predicate, object);
    }

    @Override
    protected Iterator<BindingHDTId> makeNextStage(final BindingHDTId input) {
        HDTId id;
        ++numSearches;
        if (this.var[0] != null && (id = (HDTId)input.get(this.var[0])) != null) {
            this.patternID.setSubject(NodeDictionary.translate(this.dictionary, id, TripleComponentRole.SUBJECT));
        }
        if (this.var[1] != null && (id = (HDTId)input.get(this.var[1])) != null) {
            this.patternID.setPredicate(NodeDictionary.translate(this.dictionary, id, TripleComponentRole.PREDICATE));
        }
        if (this.var[2] != null && (id = (HDTId)input.get(this.var[2])) != null) {
            this.patternID.setObject(NodeDictionary.translate(this.dictionary, id, TripleComponentRole.OBJECT));
        }
        if (this.patternID.getSubject() == -1 || this.patternID.getPredicate() == -1 || this.patternID.getObject() == -1) {
            return Iter.nullIter();
        }
        IteratorTripleID iterTripleIDSearch = this.triples.search(this.patternID);
        Iter<TripleID> it = Iter.iter(iterTripleIDSearch);
        if (this.varIsSO[0] || this.varIsSO[2]) {
            it = it.filter(new Predicate<TripleID>(){

                @Override
                public boolean test(TripleID t) {
                    if (StageMatchTripleID.this.varIsSO[0] && (long)t.getSubject() > StageMatchTripleID.this.numSharedSO) {
                        return false;
                    }
                    return !StageMatchTripleID.this.varIsSO[2] || (long)t.getObject() <= StageMatchTripleID.this.numSharedSO;
                }
            });
        }
        Function<TripleID, BindingHDTId> binder = new Function<TripleID, BindingHDTId>(){

            @Override
            public BindingHDTId apply(TripleID triple) {
                BindingHDTId output = new BindingHDTId(input);
                if (StageMatchTripleID.this.var[0] != null && !output.containsKey(StageMatchTripleID.this.var[0])) {
                    output.put(StageMatchTripleID.this.var[0], new HDTId(triple.getSubject(), TripleComponentRole.SUBJECT, StageMatchTripleID.this.dictionary));
                }
                if (StageMatchTripleID.this.var[1] != null && !output.containsKey(StageMatchTripleID.this.var[1])) {
                    output.put(StageMatchTripleID.this.var[1], new HDTId(triple.getPredicate(), TripleComponentRole.PREDICATE, StageMatchTripleID.this.dictionary));
                }
                if (StageMatchTripleID.this.var[2] != null && !output.containsKey(StageMatchTripleID.this.var[2])) {
                    output.put(StageMatchTripleID.this.var[2], new HDTId(triple.getObject(), TripleComponentRole.OBJECT, StageMatchTripleID.this.dictionary));
                }
                return output;
            }
        };
        return it.map(binder);
    }
}

