/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.Context;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdUtils;
import com.github.jsonldjava.core.NormalizeUtils;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.UniqueNamer;
import com.github.jsonldjava.utils.Obj;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLdApi {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    JsonLdOptions opts;
    Object value = null;
    Context context = null;
    private final Map<String, String> blankNodeIdentifierMap = new LinkedHashMap<String, String>();
    private int blankNodeCounter = 0;
    private Map<String, Object> nodeMap;

    public JsonLdApi() {
        this(new JsonLdOptions(""));
    }

    public JsonLdApi(Object input, JsonLdOptions opts) throws JsonLdError {
        this(opts);
        this.initialize(input, null);
    }

    public JsonLdApi(Object input, Object context, JsonLdOptions opts) throws JsonLdError {
        this(opts);
        this.initialize(input, null);
    }

    public JsonLdApi(JsonLdOptions opts) {
        if (opts == null) {
            opts = new JsonLdOptions("");
        } else {
            this.opts = opts;
        }
    }

    private void initialize(Object input, Object context) throws JsonLdError {
        if (input instanceof List || input instanceof Map) {
            this.value = JsonLdUtils.clone(input);
        }
        this.context = new Context(this.opts);
        if (context != null) {
            this.context = this.context.parse(context);
        }
    }

    public Object compact(Context activeCtx, String activeProperty, Object element, boolean compactArrays) throws JsonLdError {
        if (element instanceof List) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object item : (List)element) {
                Object compactedItem = this.compact(activeCtx, activeProperty, item, compactArrays);
                if (compactedItem == null) continue;
                result.add(compactedItem);
            }
            if (compactArrays && result.size() == 1 && activeCtx.getContainer(activeProperty) == null) {
                return result.get(0);
            }
            return result;
        }
        if (element instanceof Map) {
            Object compactedValue;
            Map elem = (Map)element;
            if ((elem.containsKey("@value") || elem.containsKey("@id")) && !((compactedValue = activeCtx.compactValue(activeProperty, elem)) instanceof Map) && !(compactedValue instanceof List)) {
                return compactedValue;
            }
            boolean insideReverse = "@reverse".equals(activeProperty);
            Map<String, Object> result = Obj.newMap();
            ArrayList keys = new ArrayList(elem.keySet());
            Collections.sort(keys);
            for (String expandedProperty : keys) {
                Object alias;
                ArrayList<String> compactedValue2;
                Object expandedValue = elem.get(expandedProperty);
                if ("@id".equals(expandedProperty) || "@type".equals(expandedProperty)) {
                    if (expandedValue instanceof String) {
                        compactedValue2 = activeCtx.compactIri((String)expandedValue, "@type".equals(expandedProperty));
                    } else {
                        ArrayList<String> types = new ArrayList<String>();
                        for (String expandedType : (List)expandedValue) {
                            types.add(activeCtx.compactIri(expandedType, true));
                        }
                        compactedValue2 = types.size() == 1 ? types.get(0) : types;
                    }
                    alias = activeCtx.compactIri(expandedProperty, true);
                    result.put((String)alias, compactedValue2);
                    continue;
                }
                if ("@reverse".equals(expandedProperty)) {
                    compactedValue2 = (Map)this.compact(activeCtx, "@reverse", expandedValue, compactArrays);
                    for (String property : new HashSet(compactedValue2.keySet())) {
                        ArrayList<Object> tmp;
                        Object value = compactedValue2.get(property);
                        if (!activeCtx.isReverseProperty(property).booleanValue()) continue;
                        if (!(!"@set".equals(activeCtx.getContainer(property)) && compactArrays || value instanceof List)) {
                            tmp = new ArrayList<Object>();
                            tmp.add(value);
                            result.put(property, tmp);
                        }
                        if (!result.containsKey(property)) {
                            result.put(property, value);
                        } else {
                            if (!(result.get(property) instanceof List)) {
                                tmp = new ArrayList();
                                tmp.add(result.put(property, tmp));
                            }
                            if (value instanceof List) {
                                ((List)result.get(property)).addAll((List)value);
                            } else {
                                ((List)result.get(property)).add(value);
                            }
                        }
                        compactedValue2.remove(property);
                    }
                    if (compactedValue2.isEmpty()) continue;
                    alias = activeCtx.compactIri("@reverse", true);
                    result.put((String)alias, compactedValue2);
                    continue;
                }
                if ("@index".equals(expandedProperty) && "@index".equals(activeCtx.getContainer(activeProperty))) continue;
                if ("@index".equals(expandedProperty) || "@value".equals(expandedProperty) || "@language".equals(expandedProperty)) {
                    String alias2 = activeCtx.compactIri(expandedProperty, true);
                    result.put(alias2, expandedValue);
                    continue;
                }
                if (((List)expandedValue).size() == 0) {
                    String itemActiveProperty = activeCtx.compactIri(expandedProperty, expandedValue, true, insideReverse);
                    if (!result.containsKey(itemActiveProperty)) {
                        result.put(itemActiveProperty, new ArrayList());
                    } else {
                        Object value = result.get(itemActiveProperty);
                        if (!(value instanceof List)) {
                            ArrayList<Object> tmp = new ArrayList<Object>();
                            tmp.add(value);
                            result.put(itemActiveProperty, tmp);
                        }
                    }
                }
                for (Object expandedItem : (List)expandedValue) {
                    ArrayList tmp;
                    String itemActiveProperty = activeCtx.compactIri(expandedProperty, expandedItem, true, insideReverse);
                    String container2 = activeCtx.getContainer(itemActiveProperty);
                    boolean isList = expandedItem instanceof Map && ((Map)expandedItem).containsKey("@list");
                    Object list = null;
                    if (isList) {
                        list = ((Map)expandedItem).get("@list");
                    }
                    ArrayList<ArrayList<Object>> compactedItem = this.compact(activeCtx, itemActiveProperty, isList ? list : expandedItem, compactArrays);
                    if (isList) {
                        if (!(compactedItem instanceof List)) {
                            ArrayList tmp2 = new ArrayList();
                            tmp2.add(compactedItem);
                            compactedItem = tmp2;
                        }
                        if (!"@list".equals(container2)) {
                            Map<String, Object> wrapper = Obj.newMap();
                            wrapper.put(activeCtx.compactIri("@list", true), compactedItem);
                            compactedItem = wrapper;
                            if (((Map)expandedItem).containsKey("@index")) {
                                ((Map)((Object)compactedItem)).put(activeCtx.compactIri("@index", true), ((Map)expandedItem).get("@index"));
                            }
                        } else if (result.containsKey(itemActiveProperty)) {
                            throw new JsonLdError(JsonLdError.Error.COMPACTION_TO_LIST_OF_LISTS, "There cannot be two list objects associated with an active property that has a container mapping");
                        }
                    }
                    if ("@language".equals(container2) || "@index".equals(container2)) {
                        List tmp3;
                        String mapKey;
                        Map mapObject;
                        if (result.containsKey(itemActiveProperty)) {
                            mapObject = (Map)result.get(itemActiveProperty);
                        } else {
                            mapObject = Obj.newMap();
                            result.put(itemActiveProperty, mapObject);
                        }
                        if ("@language".equals(container2) && compactedItem instanceof Map && ((Map)((Object)compactedItem)).containsKey("@value")) {
                            compactedItem = ((Map)((Object)compactedItem)).get("@value");
                        }
                        if (!mapObject.containsKey(mapKey = (String)((Map)expandedItem).get(container2))) {
                            mapObject.put(mapKey, compactedItem);
                            continue;
                        }
                        if (!(mapObject.get(mapKey) instanceof List)) {
                            tmp3 = new ArrayList();
                            tmp3.add(mapObject.put(mapKey, tmp3));
                        } else {
                            tmp3 = (List)mapObject.get(mapKey);
                        }
                        tmp3.add(compactedItem);
                        continue;
                    }
                    Boolean check = (!compactArrays || "@set".equals(container2) || "@list".equals(container2) || "@list".equals(expandedProperty) || "@graph".equals(expandedProperty)) && !(compactedItem instanceof List);
                    if (check.booleanValue()) {
                        tmp = new ArrayList();
                        tmp.add(compactedItem);
                        compactedItem = tmp;
                    }
                    if (!result.containsKey(itemActiveProperty)) {
                        result.put(itemActiveProperty, compactedItem);
                        continue;
                    }
                    if (!(result.get(itemActiveProperty) instanceof List)) {
                        tmp = new ArrayList();
                        tmp.add(result.put(itemActiveProperty, tmp));
                    }
                    if (compactedItem instanceof List) {
                        ((List)result.get(itemActiveProperty)).addAll((List)compactedItem);
                        continue;
                    }
                    ((List)result.get(itemActiveProperty)).add(compactedItem);
                }
            }
            return result;
        }
        return element;
    }

    public Object compact(Context activeCtx, String activeProperty, Object element) throws JsonLdError {
        return this.compact(activeCtx, activeProperty, element, true);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object expand(Context activeCtx, String activeProperty, Object element) throws JsonLdError {
        if (element == null) {
            return null;
        }
        if (element instanceof List) {
            ArrayList<Object> result = new ArrayList<Object>();
            Iterator iterator = ((List)element).iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                Object v = this.expand(activeCtx, activeProperty, item);
                if ("@list".equals(activeProperty) || "@list".equals(activeCtx.getContainer(activeProperty))) {
                    if (v instanceof List) throw new JsonLdError(JsonLdError.Error.LIST_OF_LISTS, "lists of lists are not permitted.");
                    if (v instanceof Map && ((Map)v).containsKey("@list")) {
                        throw new JsonLdError(JsonLdError.Error.LIST_OF_LISTS, "lists of lists are not permitted.");
                    }
                }
                if (v == null) continue;
                if (v instanceof List) {
                    result.addAll((Collection)v);
                    continue;
                }
                result.add(v);
            }
            return result;
        }
        if (element instanceof Map) {
            Map elem = (Map)element;
            if (elem.containsKey("@context")) {
                activeCtx = activeCtx.parse(elem.get("@context"));
            }
            Map<String, Object> result = Obj.newMap();
            ArrayList keys = new ArrayList(elem.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                Object reverseMap;
                Object tmp;
                Object value = elem.get(key);
                if (key.equals("@context")) continue;
                String expandedProperty = activeCtx.expandIri(key, false, true, null, null);
                Object expandedValue = null;
                if (expandedProperty == null || !expandedProperty.contains(":") && !JsonLdUtils.isKeyword(expandedProperty)) continue;
                if (JsonLdUtils.isKeyword(expandedProperty)) {
                    if ("@reverse".equals(activeProperty)) {
                        throw new JsonLdError(JsonLdError.Error.INVALID_REVERSE_PROPERTY_MAP, "a keyword cannot be used as a @reverse propery");
                    }
                    if (result.containsKey(expandedProperty)) {
                        throw new JsonLdError(JsonLdError.Error.COLLIDING_KEYWORDS, expandedProperty + " already exists in result");
                    }
                    if ("@id".equals(expandedProperty)) {
                        if (!(value instanceof String)) {
                            throw new JsonLdError(JsonLdError.Error.INVALID_ID_VALUE, "value of @id must be a string");
                        }
                        expandedValue = activeCtx.expandIri((String)value, true, false, null, null);
                    } else if ("@type".equals(expandedProperty)) {
                        if (value instanceof List) {
                            expandedValue = new ArrayList();
                            for (Object e2 : (List)value) {
                                if (!(e2 instanceof String)) {
                                    throw new JsonLdError(JsonLdError.Error.INVALID_TYPE_VALUE, "@type value must be a string or array of strings");
                                }
                                ((List)expandedValue).add(activeCtx.expandIri((String)e2, true, true, null, null));
                            }
                        } else if (value instanceof String) {
                            expandedValue = activeCtx.expandIri((String)value, true, true, null, null);
                        } else {
                            if (!(value instanceof Map)) throw new JsonLdError(JsonLdError.Error.INVALID_TYPE_VALUE, "@type value must be a string or array of strings");
                            if (((Map)value).size() != 0) {
                                throw new JsonLdError(JsonLdError.Error.INVALID_TYPE_VALUE, "@type value must be a an empty object for framing");
                            }
                            expandedValue = value;
                        }
                    } else if ("@graph".equals(expandedProperty)) {
                        expandedValue = this.expand(activeCtx, "@graph", value);
                    } else if ("@value".equals(expandedProperty)) {
                        if (value != null) {
                            if (value instanceof Map) throw new JsonLdError(JsonLdError.Error.INVALID_VALUE_OBJECT_VALUE, "value of " + expandedProperty + " must be a scalar or null");
                            if (value instanceof List) {
                                throw new JsonLdError(JsonLdError.Error.INVALID_VALUE_OBJECT_VALUE, "value of " + expandedProperty + " must be a scalar or null");
                            }
                        }
                        if ((expandedValue = value) == null) {
                            result.put("@value", null);
                            continue;
                        }
                    } else if ("@language".equals(expandedProperty)) {
                        if (!(value instanceof String)) {
                            throw new JsonLdError(JsonLdError.Error.INVALID_LANGUAGE_TAGGED_STRING, "Value of " + expandedProperty + " must be a string");
                        }
                        expandedValue = ((String)value).toLowerCase();
                    } else if ("@index".equals(expandedProperty)) {
                        if (!(value instanceof String)) {
                            throw new JsonLdError(JsonLdError.Error.INVALID_INDEX_VALUE, "Value of " + expandedProperty + " must be a string");
                        }
                        expandedValue = value;
                    } else if ("@list".equals(expandedProperty)) {
                        if (activeProperty == null || "@graph".equals(activeProperty)) continue;
                        expandedValue = this.expand(activeCtx, activeProperty, value);
                        if (!(expandedValue instanceof List)) {
                            tmp = new ArrayList();
                            tmp.add(expandedValue);
                            expandedValue = tmp;
                        }
                        for (Object e3 : (List)expandedValue) {
                            if (!(e3 instanceof Map) || !((Map)e3).containsKey("@list")) continue;
                            throw new JsonLdError(JsonLdError.Error.LIST_OF_LISTS, "A list may not contain another list");
                        }
                    } else if ("@set".equals(expandedProperty)) {
                        expandedValue = this.expand(activeCtx, activeProperty, value);
                    } else {
                        if ("@reverse".equals(expandedProperty)) {
                            if (!(value instanceof Map)) {
                                throw new JsonLdError(JsonLdError.Error.INVALID_REVERSE_VALUE, "@reverse value must be an object");
                            }
                            expandedValue = this.expand(activeCtx, "@reverse", value);
                            if (((Map)expandedValue).containsKey("@reverse")) {
                                Map reverse = (Map)((Map)expandedValue).get("@reverse");
                                for (String string : reverse.keySet()) {
                                    Object v = reverse.get(string);
                                    if (!result.containsKey(string)) {
                                        result.put(string, new ArrayList());
                                    }
                                    if (v instanceof List) {
                                        ((List)result.get(string)).addAll((List)v);
                                        continue;
                                    }
                                    ((List)result.get(string)).add(v);
                                }
                            }
                            if (((Map)expandedValue).size() <= (((Map)expandedValue).containsKey("@reverse") ? 1 : 0)) continue;
                            if (!result.containsKey("@reverse")) {
                                result.put("@reverse", Obj.newMap());
                            }
                            reverseMap = (Map)result.get("@reverse");
                            for (String string : ((Map)expandedValue).keySet()) {
                                if ("@reverse".equals(string)) continue;
                                List list = (List)((Map)expandedValue).get(string);
                                for (Object e4 : list) {
                                    if (e4 instanceof Map) {
                                        if (((Map)e4).containsKey("@value")) throw new JsonLdError(JsonLdError.Error.INVALID_REVERSE_PROPERTY_VALUE);
                                        if (((Map)e4).containsKey("@list")) {
                                            throw new JsonLdError(JsonLdError.Error.INVALID_REVERSE_PROPERTY_VALUE);
                                        }
                                    }
                                    if (!reverseMap.containsKey(string)) {
                                        reverseMap.put(string, new ArrayList());
                                    }
                                    ((List)reverseMap.get(string)).add(e4);
                                }
                            }
                            continue;
                        }
                        if ("@explicit".equals(expandedProperty) || "@default".equals(expandedProperty) || "@embed".equals(expandedProperty) || "@embedChildren".equals(expandedProperty) || "@omitDefault".equals(expandedProperty)) {
                            expandedValue = this.expand(activeCtx, expandedProperty, value);
                        }
                    }
                    if (expandedValue == null) continue;
                    result.put(expandedProperty, expandedValue);
                    continue;
                }
                if ("@language".equals(activeCtx.getContainer(key)) && value instanceof Map) {
                    expandedValue = new ArrayList();
                    for (String string : ((Map)value).keySet()) {
                        void var14_34;
                        Object v = ((Map)value).get(string);
                        if (!(v instanceof List)) {
                            Object v2 = v;
                            ArrayList arrayList = new ArrayList();
                            ((List)arrayList).add(v2);
                        }
                        for (Object item : (List)var14_34) {
                            if (!(item instanceof String)) {
                                throw new JsonLdError(JsonLdError.Error.INVALID_LANGUAGE_MAP_VALUE, "Expected " + item.toString() + " to be a string");
                            }
                            Map<String, Object> map = Obj.newMap();
                            map.put("@value", item);
                            map.put("@language", string.toLowerCase());
                            ((List)expandedValue).add(map);
                        }
                    }
                } else if ("@index".equals(activeCtx.getContainer(key)) && value instanceof Map) {
                    expandedValue = new ArrayList();
                    ArrayList indexKeys = new ArrayList(((Map)value).keySet());
                    Collections.sort(indexKeys);
                    for (String string : indexKeys) {
                        void var15_45;
                        Object v = ((Map)value).get(string);
                        if (!(v instanceof List)) {
                            Object tmp2 = v;
                            ArrayList arrayList = new ArrayList();
                            ((List)arrayList).add(tmp2);
                        }
                        Object object = this.expand(activeCtx, key, var15_45);
                        for (Map map : (List)object) {
                            if (!map.containsKey("@index")) {
                                map.put("@index", string);
                            }
                            ((List)expandedValue).add(map);
                        }
                    }
                } else {
                    expandedValue = this.expand(activeCtx, key, value);
                }
                if (expandedValue == null) continue;
                if (!(!"@list".equals(activeCtx.getContainer(key)) || expandedValue instanceof Map && ((Map)expandedValue).containsKey("@list"))) {
                    tmp = expandedValue;
                    if (!(tmp instanceof List)) {
                        tmp = new ArrayList();
                        ((List)tmp).add(expandedValue);
                    }
                    expandedValue = Obj.newMap();
                    expandedValue.put((String)"@list", tmp);
                }
                if (activeCtx.isReverseProperty(key).booleanValue()) {
                    if (!result.containsKey("@reverse")) {
                        result.put("@reverse", Obj.newMap());
                    }
                    reverseMap = (Map)result.get("@reverse");
                    if (!(expandedValue instanceof List)) {
                        Map<String, Object> map = expandedValue;
                        expandedValue = new ArrayList();
                        ((List)expandedValue).add(map);
                    }
                    for (Object e5 : (List)expandedValue) {
                        if (e5 instanceof Map) {
                            if (((Map)e5).containsKey("@value")) throw new JsonLdError(JsonLdError.Error.INVALID_REVERSE_PROPERTY_VALUE);
                            if (((Map)e5).containsKey("@list")) {
                                throw new JsonLdError(JsonLdError.Error.INVALID_REVERSE_PROPERTY_VALUE);
                            }
                        }
                        if (!reverseMap.containsKey(expandedProperty)) {
                            reverseMap.put(expandedProperty, new ArrayList());
                        }
                        if (e5 instanceof List) {
                            ((List)reverseMap.get(expandedProperty)).addAll((List)e5);
                            continue;
                        }
                        ((List)reverseMap.get(expandedProperty)).add(e5);
                    }
                    continue;
                }
                if (!result.containsKey(expandedProperty)) {
                    result.put(expandedProperty, new ArrayList());
                }
                if (expandedValue instanceof List) {
                    ((List)result.get(expandedProperty)).addAll((List)expandedValue);
                    continue;
                }
                ((List)result.get(expandedProperty)).add(expandedValue);
            }
            if (result.containsKey("@value")) {
                HashSet<String> keySet = new HashSet<String>(result.keySet());
                keySet.remove("@value");
                keySet.remove("@index");
                boolean langremoved = keySet.remove("@language");
                boolean typeremoved = keySet.remove("@type");
                if (langremoved) {
                    if (typeremoved) throw new JsonLdError(JsonLdError.Error.INVALID_VALUE_OBJECT, "value object has unknown keys");
                }
                if (!keySet.isEmpty()) {
                    throw new JsonLdError(JsonLdError.Error.INVALID_VALUE_OBJECT, "value object has unknown keys");
                }
                Object rval = result.get("@value");
                if (rval == null) {
                    return null;
                }
                if (!(rval instanceof String) && result.containsKey("@language")) {
                    throw new JsonLdError(JsonLdError.Error.INVALID_LANGUAGE_TAGGED_VALUE, "when @language is used, @value must be a string");
                }
                if (result.containsKey("@type")) {
                    if (!(result.get("@type") instanceof String)) throw new JsonLdError(JsonLdError.Error.INVALID_TYPED_VALUE, "value of @type must be an IRI");
                    if (((String)result.get("@type")).startsWith("_:")) throw new JsonLdError(JsonLdError.Error.INVALID_TYPED_VALUE, "value of @type must be an IRI");
                    if (!((String)result.get("@type")).contains(":")) {
                        throw new JsonLdError(JsonLdError.Error.INVALID_TYPED_VALUE, "value of @type must be an IRI");
                    }
                }
            } else if (result.containsKey("@type")) {
                Object rtype = result.get("@type");
                if (!(rtype instanceof List)) {
                    ArrayList<Object> tmp = new ArrayList<Object>();
                    tmp.add(rtype);
                    result.put("@type", tmp);
                }
            } else if (result.containsKey("@set") || result.containsKey("@list")) {
                if (result.size() > (result.containsKey("@index") ? 2 : 1)) {
                    throw new JsonLdError(JsonLdError.Error.INVALID_SET_OR_LIST_OBJECT, "@set or @list may only contain @index");
                }
                if (result.containsKey("@set")) {
                    return result.get("@set");
                }
            }
            if (result.containsKey("@language") && result.size() == 1) {
                result = null;
            }
            if (activeProperty != null) {
                if (!"@graph".equals(activeProperty)) return result;
            }
            if (result != null) {
                if (result.size() == 0) return null;
                if (result.containsKey("@value")) return null;
                if (result.containsKey("@list")) {
                    return null;
                }
            }
            if (result == null) return result;
            if (!result.containsKey("@id")) return result;
            if (result.size() != 1) return result;
            return null;
        }
        if (activeProperty == null) return null;
        if (!"@graph".equals(activeProperty)) return activeCtx.expandValue(activeProperty, element);
        return null;
    }

    public Object expand(Context activeCtx, Object element) throws JsonLdError {
        return this.expand(activeCtx, null, element);
    }

    void generateNodeMap(Object element, Map<String, Object> nodeMap) throws JsonLdError {
        this.generateNodeMap(element, nodeMap, "@default", null, null, null);
    }

    void generateNodeMap(Object element, Map<String, Object> nodeMap, String activeGraph) throws JsonLdError {
        this.generateNodeMap(element, nodeMap, activeGraph, null, null, null);
    }

    /*
     * WARNING - void declaration
     */
    void generateNodeMap(Object element, Map<String, Object> nodeMap, String activeGraph, Object activeSubject, String activeProperty, Map<String, Object> list) throws JsonLdError {
        if (element instanceof List) {
            for (Object item : (List)element) {
                this.generateNodeMap(item, nodeMap, activeGraph, activeSubject, activeProperty, list);
            }
            return;
        }
        Map elem = (Map)element;
        if (!nodeMap.containsKey(activeGraph)) {
            nodeMap.put(activeGraph, Obj.newMap());
        }
        Map graph = (Map)nodeMap.get(activeGraph);
        Map node = activeSubject == null ? null : graph.get(activeSubject);
        if (elem.containsKey("@type")) {
            List<String> oldTypes;
            ArrayList<String> newTypes = new ArrayList<String>();
            if (elem.get("@type") instanceof List) {
                oldTypes = (List)elem.get("@type");
            } else {
                oldTypes = new ArrayList();
                oldTypes.add((String)elem.get("@type"));
            }
            for (String string : oldTypes) {
                if (string.startsWith("_:")) {
                    newTypes.add(this.generateBlankNodeIdentifier(string));
                    continue;
                }
                newTypes.add(string);
            }
            if (elem.get("@type") instanceof List) {
                elem.put("@type", newTypes);
            } else {
                elem.put("@type", newTypes.get(0));
            }
        }
        if (elem.containsKey("@value")) {
            if (list == null) {
                JsonLdUtils.mergeValue(node, activeProperty, elem);
            } else {
                JsonLdUtils.mergeValue(list, "@list", elem);
            }
        } else if (elem.containsKey("@list")) {
            Map<String, Object> result = Obj.newMap("@list", new ArrayList());
            this.generateNodeMap(elem.get("@list"), nodeMap, activeGraph, activeSubject, activeProperty, result);
            JsonLdUtils.mergeValue(node, activeProperty, result);
        } else {
            String id = (String)elem.remove("@id");
            if (id != null) {
                if (id.startsWith("_:")) {
                    id = this.generateBlankNodeIdentifier(id);
                }
            } else {
                id = this.generateBlankNodeIdentifier(null);
            }
            if (!graph.containsKey(id)) {
                Map<String, Object> tmp = Obj.newMap("@id", id);
                graph.put(id, tmp);
            }
            if (activeSubject instanceof Map) {
                JsonLdUtils.mergeValue((Map)graph.get(id), activeProperty, activeSubject);
            } else if (activeProperty != null) {
                Map<String, Object> reference = Obj.newMap("@id", id);
                if (list == null) {
                    JsonLdUtils.mergeValue(node, activeProperty, reference);
                } else {
                    JsonLdUtils.mergeValue(list, "@list", reference);
                }
            }
            node = (Map)graph.get(id);
            if (elem.containsKey("@type")) {
                for (Object type : (List)elem.remove("@type")) {
                    JsonLdUtils.mergeValue(node, "@type", type);
                }
            }
            if (elem.containsKey("@index")) {
                Object elemIndex = elem.remove("@index");
                if (node.containsKey("@index")) {
                    if (!JsonLdUtils.deepCompare(node.get("@index"), elemIndex).booleanValue()) {
                        throw new JsonLdError(JsonLdError.Error.CONFLICTING_INDEXES);
                    }
                } else {
                    node.put("@index", elemIndex);
                }
            }
            if (elem.containsKey("@reverse")) {
                Map<String, Object> referencedNode = Obj.newMap("@id", id);
                Map reverseMap = (Map)elem.remove("@reverse");
                for (String property : reverseMap.keySet()) {
                    List values = (List)reverseMap.get(property);
                    for (Object value : values) {
                        this.generateNodeMap(value, nodeMap, activeGraph, referencedNode, property, null);
                    }
                }
            }
            if (elem.containsKey("@graph")) {
                this.generateNodeMap(elem.remove("@graph"), nodeMap, id, null, null, null);
            }
            ArrayList keys = new ArrayList(elem.keySet());
            Collections.sort(keys);
            for (String string : keys) {
                void var13_21;
                Object value = elem.get(string);
                if (string.startsWith("_:")) {
                    String string2 = this.generateBlankNodeIdentifier(string);
                }
                if (!node.containsKey(var13_21)) {
                    node.put(var13_21, new ArrayList());
                }
                this.generateNodeMap(value, nodeMap, activeGraph, id, (String)var13_21, null);
            }
        }
    }

    String generateBlankNodeIdentifier(String id) {
        if (id != null && this.blankNodeIdentifierMap.containsKey(id)) {
            return this.blankNodeIdentifierMap.get(id);
        }
        String bnid = "_:b" + this.blankNodeCounter++;
        if (id != null) {
            this.blankNodeIdentifierMap.put(id, bnid);
        }
        return bnid;
    }

    String generateBlankNodeIdentifier() {
        return this.generateBlankNodeIdentifier(null);
    }

    public List<Object> frame(Object input, List<Object> frame) throws JsonLdError {
        FramingContext state = new FramingContext(this.opts);
        TreeMap<String, Object> nodes = new TreeMap<String, Object>();
        this.generateNodeMap(input, nodes);
        this.nodeMap = (Map)nodes.get("@default");
        ArrayList<Object> framed = new ArrayList<Object>();
        this.frame(state, this.nodeMap, frame != null && frame.size() > 0 ? (Map)frame.get(0) : Obj.newMap(), framed, null);
        return framed;
    }

    private void frame(FramingContext state, Map<String, Object> nodes, Map<String, Object> frame, Object parent, String property) throws JsonLdError {
        Map<String, Object> matches = this.filterNodes(state, nodes, frame);
        Boolean embedOn = this.getFrameFlag(frame, "@embed", state.embed);
        Boolean explicicOn = this.getFrameFlag(frame, "@explicit", state.explicit);
        ArrayList<String> ids = new ArrayList<String>(matches.keySet());
        Collections.sort(ids);
        for (String id : ids) {
            if (property == null) {
                state.embeds = new LinkedHashMap<String, EmbedNode>();
            }
            Map<String, Object> output = Obj.newMap();
            output.put("@id", id);
            EmbedNode embeddedNode = new EmbedNode();
            embeddedNode.parent = parent;
            embeddedNode.property = property;
            if (embedOn.booleanValue() && state.embeds.containsKey(id)) {
                EmbedNode existing = state.embeds.get(id);
                embedOn = false;
                if (existing.parent instanceof List) {
                    for (Object p : (List)existing.parent) {
                        if (!JsonLdUtils.compareValues(output, p)) continue;
                        embedOn = true;
                        break;
                    }
                } else if (((Map)existing.parent).containsKey(existing.property)) {
                    for (Object v : (List)((Map)existing.parent).get(existing.property)) {
                        if (!(v instanceof Map) || !Obj.equals(id, ((Map)v).get("@id"))) continue;
                        embedOn = true;
                        break;
                    }
                }
                if (embedOn.booleanValue()) {
                    JsonLdApi.removeEmbed(state, id);
                }
            }
            if (!embedOn.booleanValue()) {
                JsonLdApi.addFrameOutput(state, parent, property, output);
                continue;
            }
            state.embeds.put(id, embeddedNode);
            Map element = (Map)matches.get(id);
            ArrayList<Object> props = new ArrayList(element.keySet());
            Collections.sort(props);
            for (String string : props) {
                if (JsonLdUtils.isKeyword(string)) {
                    output.put(string, JsonLdUtils.clone(element.get(string)));
                    continue;
                }
                if (!frame.containsKey(string)) {
                    if (explicicOn.booleanValue()) continue;
                    this.embedValues(state, element, string, output);
                    continue;
                }
                List value = (List)element.get(string);
                for (Object item : value) {
                    if (item instanceof Map && ((Map)item).containsKey("@list")) {
                        Map<String, Object> list = Obj.newMap();
                        list.put("@list", new ArrayList());
                        JsonLdApi.addFrameOutput(state, output, string, list);
                        for (Object listitem : (List)((Map)item).get("@list")) {
                            if (JsonLdUtils.isNodeReference(listitem)) {
                                Map<String, Object> tmp = Obj.newMap();
                                String itemid = (String)((Map)listitem).get("@id");
                                tmp.put(itemid, this.nodeMap.get(itemid));
                                this.frame(state, tmp, (Map)((List)frame.get(string)).get(0), list, "@list");
                                continue;
                            }
                            JsonLdApi.addFrameOutput(state, list, "@list", listitem);
                        }
                        continue;
                    }
                    if (JsonLdUtils.isNodeReference(item)) {
                        Map<String, Object> tmp = Obj.newMap();
                        String itemid = (String)((Map)item).get("@id");
                        tmp.put(itemid, this.nodeMap.get(itemid));
                        this.frame(state, tmp, (Map)((List)frame.get(string)).get(0), output, string);
                        continue;
                    }
                    JsonLdApi.addFrameOutput(state, output, string, item);
                }
            }
            props = new ArrayList<String>(frame.keySet());
            Collections.sort(props);
            for (String string : props) {
                boolean omitDefaultOn;
                Map<String, Object> propertyFrame;
                if (JsonLdUtils.isKeyword(string)) continue;
                List pf = (List)frame.get(string);
                Map<String, Object> map = propertyFrame = pf.size() > 0 ? (Map<String, Object>)pf.get(0) : null;
                if (propertyFrame == null) {
                    propertyFrame = Obj.newMap();
                }
                if ((omitDefaultOn = this.getFrameFlag(propertyFrame, "@omitDefault", state.omitDefault).booleanValue()) || output.containsKey(string)) continue;
                ArrayList def = "@null";
                if (propertyFrame.containsKey("@default")) {
                    def = JsonLdUtils.clone(propertyFrame.get("@default"));
                }
                if (!(def instanceof List)) {
                    ArrayList tmp = new ArrayList();
                    tmp.add(def);
                    def = tmp;
                }
                Map<String, Object> tmp1 = Obj.newMap("@preserve", def);
                ArrayList<Map<String, Object>> tmp2 = new ArrayList<Map<String, Object>>();
                tmp2.add(tmp1);
                output.put(string, tmp2);
            }
            JsonLdApi.addFrameOutput(state, parent, property, output);
        }
    }

    private Boolean getFrameFlag(Map<String, Object> frame, String name, boolean thedefault) {
        Object value = frame.get(name);
        if (value instanceof List && ((List)value).size() > 0) {
            value = ((List)value).get(0);
        }
        if (value instanceof Map && ((Map)value).containsKey("@value")) {
            value = ((Map)value).get("@value");
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return thedefault;
    }

    private static void removeEmbed(FramingContext state, String id) {
        Map<String, EmbedNode> embeds = state.embeds;
        EmbedNode embed = embeds.get(id);
        Object parent = embed.parent;
        String property = embed.property;
        Map<String, Object> node = Obj.newMap("@id", id);
        if (JsonLdUtils.isNode(parent)) {
            ArrayList<Map<String, Object>> newvals = new ArrayList<Map<String, Object>>();
            List oldvals = (List)((Map)parent).get(property);
            for (Object v : oldvals) {
                if (v instanceof Map && Obj.equals(((Map)v).get("@id"), id)) {
                    newvals.add(node);
                    continue;
                }
                newvals.add((Map<String, Object>)v);
            }
            ((Map)parent).put(property, newvals);
        }
        JsonLdApi.removeDependents(embeds, id);
    }

    private static void removeDependents(Map<String, EmbedNode> embeds, String id) {
        for (String id_dep : embeds.keySet()) {
            String pid;
            EmbedNode e2 = embeds.get(id_dep);
            Object p = e2.parent != null ? e2.parent : Obj.newMap();
            if (!(p instanceof Map) || !Obj.equals(id, pid = (String)((Map)p).get("@id"))) continue;
            embeds.remove(id_dep);
            JsonLdApi.removeDependents(embeds, id_dep);
        }
    }

    private Map<String, Object> filterNodes(FramingContext state, Map<String, Object> nodes, Map<String, Object> frame) throws JsonLdError {
        Map<String, Object> rval = Obj.newMap();
        for (String id : nodes.keySet()) {
            Map element = (Map)nodes.get(id);
            if (element == null || !this.filterNode(state, element, frame)) continue;
            rval.put(id, element);
        }
        return rval;
    }

    private boolean filterNode(FramingContext state, Map<String, Object> node, Map<String, Object> frame) throws JsonLdError {
        Object types = frame.get("@type");
        if (types != null) {
            if (!(types instanceof List)) {
                throw new JsonLdError(JsonLdError.Error.SYNTAX_ERROR, "frame @type must be an array");
            }
            ArrayList nodeTypes = node.get("@type");
            if (nodeTypes == null) {
                nodeTypes = new ArrayList();
            } else if (!(nodeTypes instanceof List)) {
                throw new JsonLdError(JsonLdError.Error.SYNTAX_ERROR, "node @type must be an array");
            }
            if (((List)types).size() == 1 && ((List)types).get(0) instanceof Map && ((Map)((List)types).get(0)).size() == 0) {
                return !((List)nodeTypes).isEmpty();
            }
            for (Object i : (List)nodeTypes) {
                for (Object j : (List)types) {
                    if (!JsonLdUtils.deepCompare(i, j).booleanValue()) continue;
                    return true;
                }
            }
            return false;
        }
        for (String key : frame.keySet()) {
            if (!"@id".equals(key) && (JsonLdUtils.isKeyword(key) || node.containsKey(key))) continue;
            return false;
        }
        return true;
    }

    private static void addFrameOutput(FramingContext state, Object parent, String property, Object output) {
        if (parent instanceof Map) {
            ArrayList<Object> prop = (ArrayList<Object>)((Map)parent).get(property);
            if (prop == null) {
                prop = new ArrayList<Object>();
                ((Map)parent).put(property, prop);
            }
            prop.add(output);
        } else {
            ((List)parent).add(output);
        }
    }

    private void embedValues(FramingContext state, Map<String, Object> element, String property, Object output) {
        List objects = (List)element.get(property);
        for (Object o : objects) {
            if (JsonLdUtils.isNodeReference(o)) {
                String sid = (String)((Map)o).get("@id");
                if (!state.embeds.containsKey(sid)) {
                    EmbedNode embed = new EmbedNode();
                    embed.parent = output;
                    embed.property = property;
                    state.embeds.put(sid, embed);
                    o = Obj.newMap();
                    Map<String, Object> s = (Map<String, Object>)this.nodeMap.get(sid);
                    if (s == null) {
                        s = Obj.newMap("@id", sid);
                    }
                    for (String prop : s.keySet()) {
                        if (JsonLdUtils.isKeyword(prop)) {
                            ((Map)o).put(prop, JsonLdUtils.clone(s.get(prop)));
                            continue;
                        }
                        this.embedValues(state, s, prop, o);
                    }
                }
                JsonLdApi.addFrameOutput(state, output, property, o);
                continue;
            }
            JsonLdApi.addFrameOutput(state, output, property, JsonLdUtils.clone(o));
        }
    }

    public List<Object> fromRDF(RDFDataset dataset) throws JsonLdError {
        Object graph;
        LinkedHashMap<String, NodeMapNode> defaultGraph = new LinkedHashMap<String, NodeMapNode>();
        LinkedHashMap<String, Map<String, NodeMapNode>> graphMap = new LinkedHashMap<String, Map<String, NodeMapNode>>();
        graphMap.put("@default", defaultGraph);
        for (String name : dataset.graphNames()) {
            Map<String, NodeMapNode> nodeMap;
            graph = dataset.getQuads(name);
            if (!graphMap.containsKey(name)) {
                nodeMap = new LinkedHashMap();
                graphMap.put(name, nodeMap);
            } else {
                nodeMap = (Map)graphMap.get(name);
            }
            if (!"@default".equals(name) && !Obj.contains(defaultGraph, name)) {
                defaultGraph.put(name, new NodeMapNode(name));
            }
            Iterator<Object> iterator = graph.iterator();
            while (iterator.hasNext()) {
                NodeMapNode node;
                RDFDataset.Quad triple = (RDFDataset.Quad)iterator.next();
                String subject = triple.getSubject().getValue();
                String predicate = triple.getPredicate().getValue();
                RDFDataset.Node object = triple.getObject();
                if (!nodeMap.containsKey(subject)) {
                    node = new NodeMapNode(subject);
                    nodeMap.put(subject, node);
                } else {
                    node = (NodeMapNode)nodeMap.get(subject);
                }
                if ((object.isIRI() || object.isBlankNode()) && !nodeMap.containsKey(object.getValue())) {
                    nodeMap.put(object.getValue(), new NodeMapNode(object.getValue()));
                }
                if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type".equals(predicate) && (object.isIRI() || object.isBlankNode()) && !this.opts.getUseRdfType().booleanValue()) {
                    JsonLdUtils.mergeValue(node, "@type", object.getValue());
                    continue;
                }
                Map<String, Object> value = object.toObject(this.opts.getUseNativeTypes());
                JsonLdUtils.mergeValue(node, predicate, value);
                if (!object.isBlankNode() && !object.isIRI()) continue;
                ((NodeMapNode)nodeMap.get((Object)object.getValue())).usages.add(new UsagesNode(node, predicate, value));
            }
        }
        for (String name : graphMap.keySet()) {
            graph = (Map)graphMap.get(name);
            if (!graph.containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil")) continue;
            NodeMapNode nil = (NodeMapNode)graph.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
            for (UsagesNode usage : nil.usages) {
                NodeMapNode node = usage.node;
                String property = usage.property;
                Map<String, Object> head = usage.value;
                ArrayList list = new ArrayList();
                ArrayList<String> listNodes = new ArrayList<String>();
                while ("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest".equals(property) && node.isWellFormedListNode()) {
                    list.add(((List)node.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#first")).get(0));
                    listNodes.add((String)node.get("@id"));
                    UsagesNode nodeUsage = node.usages.get(0);
                    node = nodeUsage.node;
                    property = nodeUsage.property;
                    head = nodeUsage.value;
                    if (JsonLdUtils.isBlankNode(node)) continue;
                    break;
                }
                if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#first".equals(property)) {
                    if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil".equals(node.get("@id"))) continue;
                    String headId = (String)head.get("@id");
                    head = (Map<String, Object>)((List)((NodeMapNode)graph.get(headId)).get("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest")).get(0);
                    list.remove(list.size() - 1);
                    listNodes.remove(listNodes.size() - 1);
                }
                head.remove("@id");
                Collections.reverse(list);
                head.put("@list", list);
                for (String nodeId : listNodes) {
                    graph.remove(nodeId);
                }
            }
        }
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList ids = new ArrayList(defaultGraph.keySet());
        Collections.sort(ids);
        for (String subject : ids) {
            NodeMapNode node = (NodeMapNode)defaultGraph.get(subject);
            if (graphMap.containsKey(subject)) {
                node.put("@graph", new ArrayList());
                ArrayList keys = new ArrayList(((Map)graphMap.get(subject)).keySet());
                Collections.sort(keys);
                for (String s : keys) {
                    NodeMapNode n = (NodeMapNode)((Map)graphMap.get(subject)).get(s);
                    if (n.size() == 1 && n.containsKey("@id")) continue;
                    ((List)node.get("@graph")).add(n.serialize());
                }
            }
            if (node.size() == 1 && node.containsKey("@id")) continue;
            result.add(node.serialize());
        }
        return result;
    }

    public RDFDataset toRDF() throws JsonLdError {
        Map<String, Object> nodeMap = Obj.newMap();
        nodeMap.put("@default", Obj.newMap());
        this.generateNodeMap(this.value, nodeMap);
        RDFDataset dataset = new RDFDataset(this);
        for (String graphName : nodeMap.keySet()) {
            if (JsonLdUtils.isRelativeIri(graphName)) continue;
            Map graph = (Map)nodeMap.get(graphName);
            dataset.graphToRDF(graphName, graph);
        }
        return dataset;
    }

    public Object normalize(Map<String, Object> dataset) throws JsonLdError {
        ArrayList<Object> quads = new ArrayList<Object>();
        Map<String, Object> bnodes = Obj.newMap();
        for (String graphName : dataset.keySet()) {
            List triples = (List)dataset.get(graphName);
            if ("@default".equals(graphName)) {
                graphName = null;
            }
            for (Map quad : triples) {
                String[] attrs;
                if (graphName != null) {
                    Map<String, Object> tmp;
                    if (graphName.indexOf("_:") == 0) {
                        tmp = Obj.newMap();
                        tmp.put("type", "blank node");
                        tmp.put("value", graphName);
                        quad.put("name", tmp);
                    } else {
                        tmp = Obj.newMap();
                        tmp.put("type", "IRI");
                        tmp.put("value", graphName);
                        quad.put("name", tmp);
                    }
                }
                quads.add(quad);
                for (String attr : attrs = new String[]{"subject", "object", "name"}) {
                    if (!quad.containsKey(attr) || !"blank node".equals(((Map)quad.get(attr)).get("type"))) continue;
                    String id = (String)((Map)quad.get(attr)).get("value");
                    if (!bnodes.containsKey(id)) {
                        bnodes.put(id, new LinkedHashMap<String, List<Object>>(){
                            {
                                this.put("quads", new ArrayList());
                            }
                        });
                    }
                    ((List)((Map)bnodes.get(id)).get("quads")).add(quad);
                }
            }
        }
        NormalizeUtils normalizeUtils = new NormalizeUtils(quads, bnodes, new UniqueNamer("_:c14n"), this.opts);
        return normalizeUtils.hashBlankNodes(bnodes.keySet());
    }

    private class NodeMapNode
    extends LinkedHashMap<String, Object> {
        public List<UsagesNode> usages = new ArrayList<UsagesNode>();

        public NodeMapNode(String id) {
            this.put("@id", id);
        }

        public boolean isWellFormedListNode() {
            if (this.usages.size() != 1) {
                return false;
            }
            int keys = 0;
            if (this.containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#first")) {
                ++keys;
                if (!(this.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#first") instanceof List) || ((List)this.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#first")).size() != 1) {
                    return false;
                }
            }
            if (this.containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest")) {
                ++keys;
                if (!(this.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest") instanceof List) || ((List)this.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest")).size() != 1) {
                    return false;
                }
            }
            if (this.containsKey("@type")) {
                ++keys;
                if ((!(this.get("@type") instanceof List) || ((List)this.get("@type")).size() != 1) && "http://www.w3.org/1999/02/22-rdf-syntax-ns#List".equals(((List)this.get("@type")).get(0))) {
                    return false;
                }
            }
            if (this.containsKey("@id")) {
                ++keys;
            }
            return keys >= this.size();
        }

        public Map<String, Object> serialize() {
            return new LinkedHashMap<String, Object>(this);
        }
    }

    private class UsagesNode {
        public NodeMapNode node = null;
        public String property = null;
        public Map<String, Object> value = null;

        public UsagesNode(NodeMapNode node, String property, Map<String, Object> value) {
            this.node = node;
            this.property = property;
            this.value = value;
        }
    }

    private class EmbedNode {
        public Object parent = null;
        public String property = null;

        private EmbedNode() {
        }
    }

    private class FramingContext {
        public boolean embed = true;
        public boolean explicit = false;
        public boolean omitDefault = false;
        public Map<String, EmbedNode> embeds = null;

        public FramingContext() {
        }

        public FramingContext(JsonLdOptions opts) {
            this();
            if (opts.getEmbed() != null) {
                this.embed = opts.getEmbed();
            }
            if (opts.getExplicit() != null) {
                this.explicit = opts.getExplicit();
            }
            if (opts.getOmitDefault() != null) {
                this.omitDefault = opts.getOmitDefault();
            }
        }
    }
}

