/*
 * Decompiled with CFR 0.152.
 */
package fr.datatourisme;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdtjena.HDTGraph;

public class HDTQuery {
    private String hdtFile;

    public HDTQuery(String hdtFile) {
        this.hdtFile = hdtFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getQuery(String queryStr) throws IOException, QueryParseException {
        String res = "";
        if (queryStr == null) {
            throw new QueryParseException("Empty parse error", 0, 0);
        }
        try (HDT hdt = this.mapIndex(this.hdtFile);){
            HDTGraph graph = new HDTGraph(hdt);
            Model model = ModelFactory.createModelForGraph(graph);
            Query query2 = null;
            query2 = QueryFactory.create(queryStr);
            try (QueryExecution qe = QueryExecutionFactory.create(query2, model);){
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                if (query2.isSelectType()) {
                    ResultSet results = qe.execSelect();
                    ResultSetFormatter.outputAsCSV((OutputStream)System.out, results);
                }
                if (query2.isConstructType()) {
                    Model constructModel = qe.execConstruct();
                    constructModel.write(os, "N-TRIPLE");
                }
                if (query2.isAskType()) {
                    boolean ask = qe.execAsk();
                    os.write(ask ? 1 : 0);
                }
                if (query2.isDescribeType()) {
                    Model constructModel = qe.execDescribe();
                    constructModel.write(os, "N-TRIPLE");
                }
                res = os.toString();
            }
        }
        return res;
    }

    private HDT mapIndex(String hdtFile) throws IOException {
        PrintStream dummyStream = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
            }
        });
        PrintStream originalStream = System.out;
        System.setOut(dummyStream);
        HDT hdt = HDTManager.mapIndexedHDT(hdtFile, null);
        System.setOut(originalStream);
        return hdt;
    }
}

