/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.assembler.DatasetAssemblerVocab;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.modify.GraphStoreNull;
import org.apache.jena.sparql.modify.GraphStoreNullTransactional;

public class DatasetNullAssembler
extends AssemblerBase
implements Assembler {
    public static Resource getType() {
        return DatasetAssemblerVocab.tDatasetNull;
    }

    @Override
    public Object open(Assembler a, Resource root2, Mode mode) {
        boolean transactional = true;
        if (root2.hasProperty(DatasetAssemblerVocab.pTransactional)) {
            Node b = root2.getProperty(DatasetAssemblerVocab.pTransactional).getObject().asNode();
            NodeValue nv = NodeValue.makeNode(b);
            if (nv.isBoolean()) {
                transactional = nv.getBoolean();
            } else {
                Log.warn(DatasetNullAssembler.class, "Failed to recognize value for transactional setting (ignored): " + b);
            }
        }
        GraphStoreNull dsg = transactional ? new GraphStoreNullTransactional() : new GraphStoreNull();
        return DatasetFactory.wrap(dsg);
    }
}

