/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.mem.FourTupleMap;
import org.apache.jena.sparql.core.mem.PMapQuadTable;
import org.apache.jena.sparql.core.mem.QuadTable;
import org.apache.jena.sparql.core.mem.TupleSlot;

public enum QuadTableForm implements Supplier<QuadTable>,
Predicate<Set<TupleSlot>>
{
    GSPO((List)Arrays.asList(TupleSlot.GRAPH, TupleSlot.SUBJECT, TupleSlot.PREDICATE, TupleSlot.OBJECT)){

        @Override
        public PMapQuadTable get() {
            return new PMapQuadTable(this.name()){

                @Override
                protected Quad quad(Node g, Node s, Node p, Node o) {
                    return Quad.create(g, s, p, o);
                }

                @Override
                public Stream<Quad> find(Node g, Node s, Node p, Node o) {
                    return this._find(g, s, p, o);
                }

                @Override
                public void add(Quad q) {
                    this._add(q.getGraph(), q.getSubject(), q.getPredicate(), q.getObject());
                }

                @Override
                public void delete(Quad q) {
                    this._delete(q.getGraph(), q.getSubject(), q.getPredicate(), q.getObject());
                }

                @Override
                public Stream<Node> listGraphNodes() {
                    return ((FourTupleMap)this.local().get()).entryStream().map(Map.Entry::getKey);
                }
            };
        }
    }
    ,
    GOPS((List)Arrays.asList(TupleSlot.GRAPH, TupleSlot.OBJECT, TupleSlot.PREDICATE, TupleSlot.SUBJECT)){

        @Override
        public PMapQuadTable get() {
            return new PMapQuadTable(this.name()){

                @Override
                protected Quad quad(Node g, Node o, Node p, Node s) {
                    return Quad.create(g, s, p, o);
                }

                @Override
                public Stream<Quad> find(Node g, Node s, Node p, Node o) {
                    return this._find(g, o, p, s);
                }

                @Override
                public void add(Quad q) {
                    this._add(q.getGraph(), q.getObject(), q.getPredicate(), q.getSubject());
                }

                @Override
                public void delete(Quad q) {
                    this._delete(q.getGraph(), q.getObject(), q.getPredicate(), q.getSubject());
                }
            };
        }
    }
    ,
    SPOG((List)Arrays.asList(TupleSlot.SUBJECT, TupleSlot.PREDICATE, TupleSlot.OBJECT, TupleSlot.GRAPH)){

        @Override
        public PMapQuadTable get() {
            return new PMapQuadTable(this.name()){

                @Override
                protected Quad quad(Node s, Node p, Node o, Node g) {
                    return Quad.create(g, s, p, o);
                }

                @Override
                public Stream<Quad> find(Node g, Node s, Node p, Node o) {
                    return this._find(s, p, o, g);
                }

                @Override
                public Stream<Quad> findInUnionGraph(Node s, Node p, Node o) {
                    AtomicReference mostRecentlySeen = new AtomicReference();
                    return this.find(Node.ANY, s, p, o).map(Quad::asTriple).filter(t -> !mostRecentlySeen.getAndSet(t).equals(t)).map(t -> Quad.create(Quad.unionGraph, t));
                }

                @Override
                public void add(Quad q) {
                    this._add(q.getSubject(), q.getPredicate(), q.getObject(), q.getGraph());
                }

                @Override
                public void delete(Quad q) {
                    this._delete(q.getSubject(), q.getPredicate(), q.getObject(), q.getGraph());
                }
            };
        }
    }
    ,
    OSGP((List)Arrays.asList(TupleSlot.OBJECT, TupleSlot.SUBJECT, TupleSlot.GRAPH, TupleSlot.PREDICATE)){

        @Override
        public PMapQuadTable get() {
            return new PMapQuadTable(this.name()){

                @Override
                protected Quad quad(Node o, Node s, Node g, Node p) {
                    return Quad.create(g, s, p, o);
                }

                @Override
                public Stream<Quad> find(Node g, Node s, Node p, Node o) {
                    return this._find(o, s, g, p);
                }

                @Override
                public void add(Quad q) {
                    this._add(q.getObject(), q.getSubject(), q.getGraph(), q.getPredicate());
                }

                @Override
                public void delete(Quad q) {
                    this._delete(q.getObject(), q.getSubject(), q.getGraph(), q.getPredicate());
                }
            };
        }
    }
    ,
    PGSO((List)Arrays.asList(TupleSlot.PREDICATE, TupleSlot.GRAPH, TupleSlot.SUBJECT, TupleSlot.OBJECT)){

        @Override
        public PMapQuadTable get() {
            return new PMapQuadTable(this.name()){

                @Override
                protected Quad quad(Node p, Node g, Node s, Node o) {
                    return Quad.create(g, s, p, o);
                }

                @Override
                public Stream<Quad> find(Node g, Node s, Node p, Node o) {
                    return this._find(p, g, s, o);
                }

                @Override
                public void add(Quad q) {
                    this._add(q.getPredicate(), q.getGraph(), q.getSubject(), q.getObject());
                }

                @Override
                public void delete(Quad q) {
                    this._delete(q.getPredicate(), q.getGraph(), q.getSubject(), q.getObject());
                }
            };
        }
    }
    ,
    OPSG((List)Arrays.asList(TupleSlot.OBJECT, TupleSlot.PREDICATE, TupleSlot.SUBJECT, TupleSlot.GRAPH)){

        @Override
        public PMapQuadTable get() {
            return new PMapQuadTable(this.name()){

                @Override
                protected Quad quad(Node o, Node p, Node s, Node g) {
                    return Quad.create(g, s, p, o);
                }

                @Override
                public Stream<Quad> find(Node g, Node s, Node p, Node o) {
                    return this._find(o, p, s, g);
                }

                @Override
                public Stream<Quad> findInUnionGraph(Node s, Node p, Node o) {
                    AtomicReference mostRecentlySeen = new AtomicReference();
                    return this.find(Node.ANY, s, p, o).map(Quad::asTriple).filter(t -> !mostRecentlySeen.getAndSet(t).equals(t)).map(t -> Quad.create(Quad.unionGraph, t));
                }

                @Override
                public void add(Quad q) {
                    this._add(q.getObject(), q.getPredicate(), q.getSubject(), q.getGraph());
                }

                @Override
                public void delete(Quad q) {
                    this._delete(q.getObject(), q.getPredicate(), q.getSubject(), q.getGraph());
                }
            };
        }
    };

    public final List<TupleSlot> fullpattern;

    private QuadTableForm(List<TupleSlot> fp) {
        this.fullpattern = fp;
    }

    @Override
    public boolean test(Set<TupleSlot> pattern) {
        for (int i = 4; i > 0; i = (int)((byte)(i - 1))) {
            EnumSet<TupleSlot> prefix = EnumSet.copyOf(this.fullpattern.subList(0, i));
            if (!prefix.equals(pattern)) continue;
            return true;
        }
        return false;
    }

    public static QuadTableForm chooseFrom(Set<TupleSlot> pattern) {
        return QuadTableForm.tableForms().filter(f -> f.test(pattern)).findFirst().orElse(GSPO);
    }

    public static Stream<QuadTableForm> tableForms() {
        return Arrays.stream(QuadTableForm.values());
    }
}

