/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.sparql.resultset.ResultSetProcessor;
import org.apache.jena.sparql.resultset.XMLResults;

public class XMLOutputResultSet
implements ResultSetProcessor,
XMLResults {
    static boolean outputExplicitUnbound = false;
    boolean outputGraphBNodeLabels = ARQ.isTrue(ARQ.outputGraphBNodeLabels);
    int index = 0;
    String stylesheetURL = null;
    boolean xmlInst = true;
    IndentedWriter out;
    int bNodeCounter = 0;
    Map<Resource, String> bNodeMap = new HashMap<Resource, String>();

    XMLOutputResultSet(OutputStream outStream) {
        this(new IndentedWriter(outStream));
    }

    XMLOutputResultSet(IndentedWriter indentedOut) {
        this.out = indentedOut;
    }

    @Override
    public void start(ResultSet rs) {
        if (this.xmlInst) {
            this.out.println("<?xml version=\"1.0\"?>");
        }
        if (this.stylesheetURL != null) {
            this.out.print("<?xml-stylesheet type=\"text/xsl\" href=\"");
            this.out.print(this.stylesheetURL);
            this.out.println("\"?>");
        }
        this.out.print("<");
        this.out.print("sparql");
        this.out.print(" xmlns=\"");
        this.out.print("http://www.w3.org/2005/sparql-results#");
        this.out.println("\">");
        this.out.incIndent(2);
        this.out.print("<");
        this.out.print("head");
        this.out.println(">");
        for (String n : rs.getResultVars()) {
            this.out.incIndent(2);
            this.out.print("<");
            this.out.print("variable");
            this.out.print(" ");
            this.out.print("name");
            this.out.print("=\"");
            this.out.print(n);
            this.out.print("\"");
            this.out.println("/>");
            this.out.decIndent(2);
        }
        this.out.print("</");
        this.out.print("head");
        this.out.println(">");
        this.out.decIndent(2);
        this.out.incIndent(2);
        this.out.print("<");
        this.out.print("results");
        this.out.println(">");
        this.out.incIndent(2);
    }

    @Override
    public void finish(ResultSet rs) {
        this.out.decIndent(2);
        this.out.print("</");
        this.out.print("results");
        this.out.println(">");
        this.out.decIndent(2);
        this.out.print("</");
        this.out.print("sparql");
        this.out.println(">");
        this.out.flush();
    }

    @Override
    public void start(QuerySolution qs) {
        this.out.print("<");
        this.out.print("result");
        this.out.println(">");
        ++this.index;
        this.out.incIndent(2);
    }

    @Override
    public void finish(QuerySolution qs) {
        this.out.decIndent(2);
        this.out.print("</");
        this.out.print("result");
        this.out.println(">");
    }

    @Override
    public void binding(String varName, RDFNode node) {
        if (node == null && !outputExplicitUnbound) {
            return;
        }
        this.out.print("<");
        this.out.print("binding");
        this.out.print(" name=\"");
        this.out.print(varName);
        this.out.println("\">");
        this.out.incIndent(2);
        this.printBindingValue(node);
        this.out.decIndent(2);
        this.out.print("</");
        this.out.print("binding");
        this.out.println(">");
    }

    void printBindingValue(RDFNode node) {
        if (node == null) {
            this.out.print("<");
            this.out.print("unbound");
            this.out.println("/>");
            return;
        }
        if (node instanceof Literal) {
            this.printLiteral((Literal)node);
            return;
        }
        if (node instanceof Resource) {
            this.printResource((Resource)node);
            return;
        }
        Log.warn(this, "Unknown RDFNode type in result set: " + node.getClass());
    }

    void printLiteral(Literal literal) {
        this.out.print("<");
        this.out.print("literal");
        if (Util.isLangString(literal)) {
            String lang = literal.getLanguage();
            this.out.print(" xml:lang=\"");
            this.out.print(literal.getLanguage());
            this.out.print("\"");
        } else if (!Util.isSimpleString(literal)) {
            String datatype = literal.getDatatypeURI();
            this.out.print(" ");
            this.out.print("datatype");
            this.out.print("=\"");
            this.out.print(datatype);
            this.out.print("\"");
        }
        this.out.print(">");
        this.out.print(XMLOutputResultSet.xml_escape(literal.getLexicalForm()));
        this.out.print("</");
        this.out.print("literal");
        this.out.println(">");
    }

    void printResource(Resource r) {
        if (r.isAnon()) {
            String label;
            if (this.outputGraphBNodeLabels) {
                label = r.asNode().getBlankNodeId().getLabelString();
            } else {
                if (!this.bNodeMap.containsKey(r)) {
                    this.bNodeMap.put(r, "b" + this.bNodeCounter++);
                }
                label = this.bNodeMap.get(r);
            }
            this.out.print("<");
            this.out.print("bnode");
            this.out.print(">");
            this.out.print(XMLOutputResultSet.xml_escape(label));
            this.out.print("</");
            this.out.print("bnode");
            this.out.println(">");
        } else {
            this.out.print("<");
            this.out.print("uri");
            this.out.print(">");
            this.out.print(XMLOutputResultSet.xml_escape(r.getURI()));
            this.out.print("</");
            this.out.print("uri");
            this.out.println(">");
        }
    }

    private static String xml_escape(String string) {
        StringBuilder sb = new StringBuilder(string);
        int offset = 0;
        for (int i = 0; i < string.length(); ++i) {
            String replacement;
            char found = string.charAt(i);
            switch (found) {
                case '&': {
                    replacement = "&amp;";
                    break;
                }
                case '<': {
                    replacement = "&lt;";
                    break;
                }
                case '>': {
                    replacement = "&gt;";
                    break;
                }
                case '\r': {
                    replacement = "&#x0D;";
                    break;
                }
                case '\n': {
                    replacement = "&#x0A;";
                    break;
                }
                default: {
                    replacement = null;
                }
            }
            if (replacement == null) continue;
            sb.replace(offset + i, offset + i + 1, replacement);
            offset += replacement.length() - 1;
        }
        return sb.toString();
    }

    public String getStylesheetURL() {
        return this.stylesheetURL;
    }

    public void setStylesheetURL(String stylesheetURL) {
        this.stylesheetURL = stylesheetURL;
    }

    public boolean getXmlInst() {
        return this.xmlInst;
    }

    public void setXmlInst(boolean xmlInst) {
        this.xmlInst = xmlInst;
    }
}

