/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax.syntaxtransform;

import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryVisitor;
import org.apache.jena.query.SortCondition;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformSubst;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformer;
import org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformApplyElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformNodeElement;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;

public class QueryTransformOps {
    public static Query transform(Query query2, Map<Var, Node> substitutions) {
        ElementTransformSubst eltrans = new ElementTransformSubst(substitutions);
        NodeTransformSubst nodeTransform = new NodeTransformSubst(substitutions);
        ExprTransformNodeElement exprTrans = new ExprTransformNodeElement(nodeTransform, eltrans);
        return QueryTransformOps.transform(query2, eltrans, exprTrans);
    }

    public static Query transform(Query query2, ElementTransform transform, ExprTransform exprTransform) {
        Query q2 = QueryTransformOps.shallowCopy(query2);
        QueryTransformOps.transformVarExprList(q2.getProject(), exprTransform);
        QueryTransformOps.transformVarExprList(q2.getGroupBy(), exprTransform);
        Element el = q2.getQueryPattern();
        Element el2 = ElementTransformer.transform(el, transform, exprTransform);
        if (!(el2 instanceof ElementGroup)) {
            ElementGroup eg = new ElementGroup();
            eg.addElement(el2);
            el2 = eg;
        }
        q2.setQueryPattern(el2);
        return q2;
    }

    public static Query transform(Query query2, ElementTransform transform) {
        ExprTransformApplyElementTransform noop = new ExprTransformApplyElementTransform(transform);
        return QueryTransformOps.transform(query2, transform, noop);
    }

    private static void transformVarExprList(VarExprList varExprList, ExprTransform exprTransform) {
        Map<Var, Expr> map = varExprList.getExprs();
        for (Var v : varExprList.getVars()) {
            Expr e2;
            Expr e3 = varExprList.getExpr(v);
            ExprVar ev = new ExprVar(v);
            Expr ev2 = exprTransform.transform(ev);
            if (ev != ev2) {
                if (e3 != null) {
                    throw new ARQException("Can't substitute " + v + " because it's used as an AS variable");
                }
                if (ev2 instanceof NodeValue) {
                    map.put(v, ev2);
                    continue;
                }
                throw new ARQException("Can't substitute " + v + " because it's not a simple value: " + ev2);
            }
            if (e3 == null || e3 == (e2 = ExprTransformer.transform(exprTransform, e3))) continue;
            map.put(v, e2);
        }
    }

    public static Query shallowCopy(Query query2) {
        QueryShallowCopy copy = new QueryShallowCopy();
        query2.visit(copy);
        Query q2 = copy.newQuery;
        return q2;
    }

    static class QueryShallowCopy
    implements QueryVisitor {
        final Query newQuery = new Query();

        QueryShallowCopy() {
        }

        @Override
        public void startVisit(Query query2) {
            this.newQuery.setSyntax(query2.getSyntax());
            if (query2.explicitlySetBaseURI()) {
                this.newQuery.setBaseURI(query2.getPrologue().getResolver());
            }
            this.newQuery.setQueryResultStar(query2.isQueryResultStar());
            if (query2.hasDatasetDescription()) {
                DatasetDescription desc = query2.getDatasetDescription();
                for (String x : desc.getDefaultGraphURIs()) {
                    this.newQuery.addGraphURI(x);
                }
                for (String x : desc.getDefaultGraphURIs()) {
                    this.newQuery.addNamedGraphURI(x);
                }
            }
            this.newQuery.getAggregators().addAll(query2.getAggregators());
        }

        @Override
        public void visitPrologue(Prologue prologue) {
            PrefixMapping pmap = new PrefixMappingImpl().setNsPrefixes(prologue.getPrefixMapping());
            this.newQuery.setPrefixMapping(pmap);
        }

        @Override
        public void visitResultForm(Query q) {
        }

        @Override
        public void visitSelectResultForm(Query query2) {
            this.newQuery.setQuerySelectType();
            this.newQuery.setDistinct(query2.isDistinct());
            VarExprList x = query2.getProject();
            for (Var v : x.getVars()) {
                Expr expr = x.getExpr(v);
                if (expr == null) {
                    this.newQuery.addResultVar(v);
                    continue;
                }
                this.newQuery.addResultVar(v, expr);
            }
        }

        @Override
        public void visitConstructResultForm(Query query2) {
            this.newQuery.setQueryConstructType();
            this.newQuery.setConstructTemplate(query2.getConstructTemplate());
        }

        @Override
        public void visitDescribeResultForm(Query query2) {
            this.newQuery.setQueryDescribeType();
            for (Node x : query2.getResultURIs()) {
                this.newQuery.addDescribeNode(x);
            }
        }

        @Override
        public void visitAskResultForm(Query query2) {
            this.newQuery.setQueryAskType();
        }

        @Override
        public void visitDatasetDecl(Query query2) {
        }

        @Override
        public void visitQueryPattern(Query query2) {
            this.newQuery.setQueryPattern(query2.getQueryPattern());
        }

        @Override
        public void visitGroupBy(Query query2) {
            if (query2.hasGroupBy()) {
                VarExprList x = query2.getGroupBy();
                for (Var v : x.getVars()) {
                    Expr expr = x.getExpr(v);
                    if (expr == null) {
                        this.newQuery.addGroupBy(v);
                        continue;
                    }
                    this.newQuery.addGroupBy(v, expr);
                }
            }
        }

        @Override
        public void visitHaving(Query query2) {
            if (query2.hasHaving()) {
                for (Expr expr : query2.getHavingExprs()) {
                    this.newQuery.addHavingCondition(expr);
                }
            }
        }

        @Override
        public void visitOrderBy(Query query2) {
            if (query2.hasOrderBy()) {
                for (SortCondition sc : query2.getOrderBy()) {
                    this.newQuery.addOrderBy(sc);
                }
            }
        }

        @Override
        public void visitLimit(Query query2) {
            this.newQuery.setLimit(query2.getLimit());
        }

        @Override
        public void visitOffset(Query query2) {
            this.newQuery.setOffset(query2.getOffset());
        }

        @Override
        public void visitValues(Query query2) {
            if (query2.hasValues()) {
                this.newQuery.setValuesDataBlock(query2.getValuesVariables(), query2.getValuesData());
            }
        }

        @Override
        public void finishVisit(Query query2) {
        }
    }
}

