/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.sequence;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.rdfhdt.hdt.compact.sequence.DynamicSequence;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.util.io.IOUtil;

public class SequenceInt64
implements DynamicSequence {
    long[] data;
    long numelements;

    public SequenceInt64() {
        this(10L);
    }

    public SequenceInt64(long capacity) {
        assert (capacity >= 0L && capacity <= Integer.MAX_VALUE);
        this.data = new long[(int)capacity];
        this.numelements = 0L;
    }

    private void resizeArray(int size) {
        long[] newData = new long[size];
        System.arraycopy(this.data, 0, newData, 0, Math.min(newData.length, this.data.length));
        this.data = newData;
    }

    @Override
    public void trimToSize() {
        this.resizeArray((int)this.numelements);
    }

    @Override
    public void aggresiveTrimToSize() {
        this.trimToSize();
    }

    @Override
    public long get(long position) {
        assert (position >= 0L && position <= Integer.MAX_VALUE);
        return this.data[(int)position];
    }

    @Override
    public void set(long position, long value) {
        assert (position >= 0L && position <= Integer.MAX_VALUE);
        assert (value >= 0L && value <= Long.MAX_VALUE);
        this.data[(int)position] = value;
        this.numelements = (int)Math.max(this.numelements, position + 1L);
    }

    @Override
    public void append(long value) {
        assert (value >= 0L && value <= Long.MAX_VALUE);
        assert (this.numelements < Long.MAX_VALUE);
        if ((long)this.data.length < this.numelements + 1L) {
            this.resizeArray(this.data.length * 2);
        }
        this.data[(int)this.numelements++] = value;
    }

    @Override
    public long getNumberOfElements() {
        return this.numelements;
    }

    @Override
    public void save(OutputStream output, ProgressListener listener) throws IOException {
        output.write(3);
        IOUtil.writeLong(output, this.numelements);
        int i = 0;
        while ((long)i < this.numelements) {
            IOUtil.writeLong(output, this.data[i]);
            ++i;
        }
    }

    @Override
    public void load(InputStream input, ProgressListener listener) throws IOException {
        int type = input.read();
        if (type != 3) {
            throw new IllegalFormatException("Trying to read INT64 but data is not INT64");
        }
        long size = IOUtil.readLong(input);
        this.numelements = 0L;
        this.data = new long[(int)size];
        for (long i = 0L; i < size; ++i) {
            this.append(IOUtil.readLong(input));
        }
    }

    @Override
    public void add(Iterator<Long> iterator) {
        while (iterator.hasNext()) {
            long value = iterator.next();
            this.append(value);
        }
    }

    public String toString() {
        throw new NotImplementedException();
    }

    @Override
    public long size() {
        return 4L * this.numelements;
    }

    @Override
    public String getType() {
        return "<http://purl.org/HDT/hdt#seqInt64>";
    }

    @Override
    public void close() throws IOException {
        this.data = null;
    }
}

