/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.io.IOException;
import java.util.Iterator;
import org.rdfhdt.hdt.dictionary.impl.BaseTempDictionary;
import org.rdfhdt.hdt.dictionary.impl.DictionaryIDMapping;
import org.rdfhdt.hdt.dictionary.impl.section.HashDictionarySection;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TempTriples;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.util.StopWatch;

public class HashDictionary
extends BaseTempDictionary {
    public HashDictionary(HDTOptions spec) {
        super(spec);
        this.subjects = new HashDictionarySection();
        this.predicates = new HashDictionarySection();
        this.objects = new HashDictionarySection();
        this.shared = new HashDictionarySection();
    }

    @Override
    public void reorganize(TempTriples triples) {
        int j;
        DictionaryIDMapping mapSubj = new DictionaryIDMapping(this.subjects.getNumberOfElements());
        DictionaryIDMapping mapPred = new DictionaryIDMapping(this.predicates.getNumberOfElements());
        DictionaryIDMapping mapObj = new DictionaryIDMapping(this.objects.getNumberOfElements());
        StopWatch st = new StopWatch();
        Iterator<? extends CharSequence> itSubj = this.subjects.getEntries();
        while (itSubj.hasNext()) {
            CharSequence str2 = itSubj.next();
            mapSubj.add(str2);
            if (str2.length() <= 0 || str2.charAt(0) == '\"' || this.objects.locate(str2) == 0) continue;
            this.shared.add(str2);
        }
        st.reset();
        Iterator<? extends CharSequence> itPred = this.predicates.getEntries();
        while (itPred.hasNext()) {
            CharSequence str3 = itPred.next();
            mapPred.add(str3);
        }
        Iterator<? extends CharSequence> itObj = this.objects.getEntries();
        while (itObj.hasNext()) {
            CharSequence str4 = itObj.next();
            mapObj.add(str4);
        }
        Iterator<? extends CharSequence> itShared = this.shared.getEntries();
        while (itShared.hasNext()) {
            CharSequence sharedStr = itShared.next();
            this.subjects.remove(sharedStr);
            this.objects.remove(sharedStr);
        }
        st.reset();
        this.subjects.sort();
        this.predicates.sort();
        this.objects.sort();
        this.shared.sort();
        st.reset();
        for (j = 0; j < mapSubj.size(); ++j) {
            mapSubj.setNewID(j, this.stringToId(mapSubj.getString(j), TripleComponentRole.SUBJECT));
        }
        for (j = 0; j < mapPred.size(); ++j) {
            mapPred.setNewID(j, this.stringToId(mapPred.getString(j), TripleComponentRole.PREDICATE));
        }
        for (j = 0; j < mapObj.size(); ++j) {
            mapObj.setNewID(j, this.stringToId(mapObj.getString(j), TripleComponentRole.OBJECT));
        }
        st.reset();
        IteratorTripleID iteratorTriples = triples.searchAll();
        while (iteratorTriples.hasNext()) {
            TripleID triple = (TripleID)iteratorTriples.next();
            triples.update(triple, mapSubj.getNewID(triple.getSubject() - 1), mapPred.getNewID(triple.getPredicate() - 1), mapObj.getNewID(triple.getObject() - 1));
        }
        this.isOrganized = true;
    }

    @Override
    public void startProcessing() {
    }

    @Override
    public void endProcessing() {
    }

    @Override
    public void close() throws IOException {
    }
}

