/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.enums;

import java.io.File;

public enum RDFNotation {
    RDFXML,
    NTRIPLES,
    TURTLE,
    N3,
    TAR,
    RAR;


    public static RDFNotation parse(String str2) {
        if (str2 == null || str2.isEmpty()) {
            return NTRIPLES;
        }
        if ((str2 = str2.toLowerCase()).equals("ntriples") || str2.equals("nt")) {
            return NTRIPLES;
        }
        if (str2.equals("n3")) {
            return N3;
        }
        if (str2.equals("rdfxml") || str2.equals("rdf-xml")) {
            return RDFXML;
        }
        if (str2.equals("turtle")) {
            return TURTLE;
        }
        if (str2.equals("rar")) {
            return RAR;
        }
        if (str2.equals("tar") || str2.equals("tgz") || str2.equals("tbz") || str2.equals("tbz2")) {
            return TAR;
        }
        throw new IllegalArgumentException();
    }

    public static RDFNotation guess(String fileName) throws IllegalArgumentException {
        String ext;
        String str2 = fileName.toLowerCase();
        int idx = str2.lastIndexOf(46);
        if (idx != -1 && ((ext = str2.substring(idx + 1, str2.length())).equals("gz") || ext.equals("bz") || ext.equals("bz2"))) {
            str2 = str2.substring(0, idx);
        }
        if (str2.endsWith("nt")) {
            return NTRIPLES;
        }
        if (str2.endsWith("n3")) {
            return N3;
        }
        if (str2.endsWith("rdf") || str2.endsWith("xml") || str2.endsWith("owl")) {
            return RDFXML;
        }
        if (str2.endsWith("ttl")) {
            return TURTLE;
        }
        if (str2.endsWith("tar") || str2.endsWith("tgz") || str2.endsWith("tbz2")) {
            return TAR;
        }
        if (str2.endsWith("rar")) {
            return RAR;
        }
        throw new IllegalArgumentException("Could not guess the format for " + fileName);
    }

    public static RDFNotation guess(File fileName) throws IllegalArgumentException {
        return RDFNotation.guess(fileName.getName());
    }
}

