/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt.impl;

import java.io.IOException;
import org.rdfhdt.hdt.dictionary.DictionaryFactory;
import org.rdfhdt.hdt.dictionary.TempDictionary;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.hdt.TempHDT;
import org.rdfhdt.hdt.hdt.impl.ModeOfLoading;
import org.rdfhdt.hdt.header.Header;
import org.rdfhdt.hdt.header.HeaderFactory;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.triples.TempTriples;
import org.rdfhdt.hdt.triples.TriplesFactory;

public class TempHDTImpl
implements TempHDT {
    protected Header header;
    protected TempDictionary dictionary;
    protected TempTriples triples;
    protected String baseUri;
    protected ModeOfLoading modeOfLoading;
    protected boolean isOrganized;
    protected long rawsize;

    public TempHDTImpl(HDTOptions spec, String baseUri, ModeOfLoading modeOfLoading) {
        this.baseUri = baseUri;
        this.modeOfLoading = modeOfLoading;
        this.header = HeaderFactory.createHeader(spec);
        this.dictionary = DictionaryFactory.createTempDictionary(spec);
        this.triples = TriplesFactory.createTempTriples(spec);
    }

    @Override
    public Header getHeader() {
        return this.header;
    }

    @Override
    public TempDictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public TempTriples getTriples() {
        return this.triples;
    }

    @Override
    public void insert(CharSequence subject, CharSequence predicate, CharSequence object) {
        this.rawsize += (long)(subject.length() + predicate.length() + object.length() + 4);
        this.triples.insert(this.dictionary.insert(subject, TripleComponentRole.SUBJECT), this.dictionary.insert(predicate, TripleComponentRole.PREDICATE), this.dictionary.insert(object, TripleComponentRole.OBJECT));
        this.isOrganized = false;
        this.modeOfLoading = null;
    }

    @Override
    public void clear() {
        this.dictionary.clear();
        this.triples.clear();
        this.isOrganized = false;
    }

    @Override
    public void close() throws IOException {
        this.dictionary.close();
        this.triples.close();
    }

    @Override
    public String getBaseURI() {
        return this.baseUri;
    }

    @Override
    public void reorganizeDictionary(ProgressListener listener) {
        if (this.isOrganized || this.dictionary.isOrganized()) {
            return;
        }
        if (ModeOfLoading.ONE_PASS.equals((Object)this.modeOfLoading)) {
            this.dictionary.reorganize(this.triples);
        } else if (ModeOfLoading.TWO_PASS.equals((Object)this.modeOfLoading)) {
            this.dictionary.reorganize();
        } else if (this.modeOfLoading == null) {
            this.dictionary.reorganize(this.triples);
        }
    }

    @Override
    public void reorganizeTriples(ProgressListener listener) {
        if (this.isOrganized) {
            return;
        }
        if (!this.dictionary.isOrganized()) {
            throw new RuntimeException("Cannot reorganize triples before dictionary is reorganized!");
        }
        this.triples.sort(listener);
        this.triples.removeDuplicates(listener);
        this.isOrganized = true;
    }

    @Override
    public boolean isOrganized() {
        return this.isOrganized;
    }

    public long getRawSize() {
        return this.rawsize;
    }
}

