/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt.impl;

import java.io.File;
import java.io.IOException;
import org.rdfhdt.hdt.dictionary.TempDictionary;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.hdt.TempHDT;
import org.rdfhdt.hdt.hdt.TempHDTImporter;
import org.rdfhdt.hdt.hdt.impl.ModeOfLoading;
import org.rdfhdt.hdt.hdt.impl.TempHDTImpl;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.rdf.RDFParserFactory;
import org.rdfhdt.hdt.triples.IteratorTripleString;
import org.rdfhdt.hdt.triples.TempTriples;
import org.rdfhdt.hdt.triples.TripleString;
import org.rdfhdt.hdt.util.RDFInfo;
import org.rdfhdt.hdt.util.listener.ListenerUtil;

public class TempHDTImporterOnePass
implements TempHDTImporter {
    @Override
    public TempHDT loadFromRDF(HDTOptions specs, String filename, String baseUri, RDFNotation notation, ProgressListener listener) throws IOException, ParserException {
        RDFParserCallback parser = RDFParserFactory.getParserCallback(notation);
        if (!RDFInfo.triplesSet(specs) && "list".equals(specs.get("tempTriples.impl"))) {
            RDFInfo.setTriples(RDFInfo.countLines(filename, parser, notation), specs);
        }
        RDFInfo.setSizeInBytes(new File(filename).length(), specs);
        TempHDTImpl modHDT = new TempHDTImpl(specs, baseUri, ModeOfLoading.ONE_PASS);
        TempDictionary dictionary = modHDT.getDictionary();
        TempTriples triples = modHDT.getTriples();
        TripleAppender appender = new TripleAppender(dictionary, triples, listener);
        dictionary.startProcessing();
        parser.doParse(filename, baseUri, notation, (RDFParserCallback.RDFCallback)appender);
        dictionary.endProcessing();
        modHDT.reorganizeDictionary(listener);
        modHDT.reorganizeTriples(listener);
        modHDT.getHeader().insert((CharSequence)"_:statistics", (CharSequence)"<http://purl.org/HDT/hdt#originalSize>", appender.size);
        return modHDT;
    }

    public TempHDT loadFromTriples(HDTOptions specs, IteratorTripleString iterator, String baseUri, ProgressListener listener) throws IOException {
        TempHDTImpl modHDT = new TempHDTImpl(specs, baseUri, ModeOfLoading.ONE_PASS);
        TempDictionary dictionary = modHDT.getDictionary();
        TempTriples triples = modHDT.getTriples();
        dictionary.startProcessing();
        long num = 0L;
        long size = 0L;
        while (iterator.hasNext()) {
            TripleString triple = (TripleString)iterator.next();
            triples.insert(dictionary.insert(triple.getSubject(), TripleComponentRole.SUBJECT), dictionary.insert(triple.getPredicate(), TripleComponentRole.PREDICATE), dictionary.insert(triple.getObject(), TripleComponentRole.OBJECT));
            size += (long)(triple.getSubject().length() + triple.getPredicate().length() + triple.getObject().length() + 4);
            ListenerUtil.notifyCond(listener, "Loaded " + ++num + " triples", num, 0.0f, 100.0f);
        }
        dictionary.endProcessing();
        modHDT.reorganizeDictionary(listener);
        modHDT.reorganizeTriples(listener);
        modHDT.getHeader().insert((CharSequence)"_:statistics", (CharSequence)"<http://purl.org/HDT/hdt#originalSize>", size);
        return modHDT;
    }

    class TripleAppender
    implements RDFParserCallback.RDFCallback {
        TempDictionary dict;
        TempTriples triples;
        ProgressListener listener;
        long num;
        long size;

        public TripleAppender(TempDictionary dict, TempTriples triples, ProgressListener listener) {
            this.dict = dict;
            this.triples = triples;
            this.listener = listener;
        }

        @Override
        public void processTriple(TripleString triple, long pos) {
            this.triples.insert(this.dict.insert(triple.getSubject(), TripleComponentRole.SUBJECT), this.dict.insert(triple.getPredicate(), TripleComponentRole.PREDICATE), this.dict.insert(triple.getObject(), TripleComponentRole.OBJECT));
            ++this.num;
            this.size += (long)(triple.getSubject().length() + triple.getPredicate().length() + triple.getObject().length() + 4);
            ListenerUtil.notifyCond(this.listener, "Loaded " + this.num + " triples", this.num, 0.0f, 100.0f);
        }
    }
}

