/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;

public class MultiMerge<T>
implements Iterator<T> {
    PriorityQueue<Source<T>> queue = new PriorityQueue();

    public MultiMerge(Iterator<Iterator<T>> it, Comparator<T> comparator) {
        while (it.hasNext()) {
            Source<T> s;
            Iterator<T> inner = it.next();
            if (!inner.hasNext() || !(s = new Source<T>(inner, comparator)).read()) continue;
            this.queue.add(s);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public T next() {
        Source item = (Source)this.queue.remove();
        Object out = item.entry;
        if (item.read()) {
            this.queue.add(item);
        }
        return out;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class Source<T>
    implements Comparable<Source<T>> {
        Comparator<T> comparator;
        Iterator<T> it;
        T entry;

        Source(Iterator<T> it, Comparator<T> comparator) {
            this.it = it;
            this.comparator = comparator;
        }

        public boolean read() {
            if (this.it.hasNext()) {
                this.entry = this.it.next();
                return true;
            }
            return false;
        }

        @Override
        public int compareTo(Source<T> o) {
            return this.comparator.compare(this.entry, o.entry);
        }
    }
}

