/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf.parsers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.rdf.RDFParserFactory;
import org.rdfhdt.hdt.util.io.ExternalDecompressStream;
import org.rdfhdt.hdt.util.io.NonCloseInputStream;

public class RDFParserTar
implements RDFParserCallback {
    @Override
    public void doParse(String fileName, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        try {
            InputStream input = fileName.equals("-") ? System.in : (fileName.endsWith(".gz") || fileName.endsWith("tgz") ? new BufferedInputStream(new GZIPInputStream(new FileInputStream(fileName))) : (fileName.endsWith("bz2") || fileName.endsWith("bz") ? new ExternalDecompressStream(new File(fileName), ExternalDecompressStream.PBZIP2) : new BufferedInputStream(new FileInputStream(fileName))));
            this.doParse(input, baseUri, notation, callback);
            input.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new ParserException();
        }
    }

    @Override
    public void doParse(InputStream input, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        try {
            TarArchiveInputStream debInputStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", input);
            TarArchiveEntry entry = null;
            NonCloseInputStream nonCloseIn = new NonCloseInputStream(debInputStream);
            while ((entry = (TarArchiveEntry)debInputStream.getNextEntry()) != null) {
                if (!entry.isFile() || entry.getName().contains("DS_Store")) continue;
                try {
                    RDFNotation guessnot = RDFNotation.guess(entry.getName());
                    System.out.println("Parse from tar: " + entry.getName() + " as " + (Object)((Object)guessnot));
                    RDFParserCallback parser = RDFParserFactory.getParserCallback(guessnot);
                    parser.doParse(nonCloseIn, baseUri, guessnot, callback);
                }
                catch (IllegalArgumentException e1) {
                    e1.printStackTrace();
                }
                catch (ParserException e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
            throw new ParserException();
        }
        catch (Exception e3) {
            e3.printStackTrace();
            throw new ParserException();
        }
    }
}

