/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;

public class ProfilingUtil {
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static volatile HotSpotDiagnosticMXBean hotspotMBean;

    private ProfilingUtil() {
    }

    public static void dumpHeap(String fileName, boolean live) {
        ProfilingUtil.initHotspotMBean();
        try {
            hotspotMBean.dumpHeap(fileName, live);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initHotspotMBean() {
        if (hotspotMBean != null) return;
        Class<ProfilingUtil> clazz = ProfilingUtil.class;
        synchronized (ProfilingUtil.class) {
            if (hotspotMBean != null) return;
            hotspotMBean = ProfilingUtil.getHotspotMBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static HotSpotDiagnosticMXBean getHotspotMBean() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            HotSpotDiagnosticMXBean bean = ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
            return bean;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    public static String tidyFileSize(long size) {
        String str2;
        if (size >= 0x40000000L) {
            long calcSize = (long)((double)size / 1.073741824E9);
            str2 = Long.toString(calcSize) + "GB";
        } else if (size >= 0x100000L) {
            long calcSize = (long)((double)size / 1048576.0);
            str2 = Long.toString(calcSize) + "MB";
        } else if (size >= 1024L) {
            long calcSize = (long)((double)size / 1024.0);
            str2 = Long.toString(calcSize) + "KB";
        } else {
            long calcSize = size;
            str2 = Long.toString(calcSize) + "B";
        }
        return str2;
    }

    public static long parseSize(String property) {
        if (property == null || property.equals("")) {
            return -1L;
        }
        property = property.trim();
        char lastChar = property.charAt(property.length() - 1);
        switch (lastChar) {
            case 'K': 
            case 'k': {
                return Long.parseLong(property.substring(0, property.length() - 1)) * 1024L;
            }
            case 'M': 
            case 'm': {
                return Long.parseLong(property.substring(0, property.length() - 1)) * 1024L * 1024L;
            }
            case 'G': 
            case 'g': {
                return Long.parseLong(property.substring(0, property.length() - 1)) * 1024L * 1024L * 1024L;
            }
        }
        return Long.parseLong(property);
    }

    public static void showMemory(String label) {
        System.out.println(label + ": " + ProfilingUtil.getMemory());
    }

    public static String getMemory() {
        return ProfilingUtil.tidyFileSize(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + " / " + ProfilingUtil.tidyFileSize(Runtime.getRuntime().totalMemory()) + " / " + ProfilingUtil.tidyFileSize(Runtime.getRuntime().maxMemory());
    }
}

