/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.string;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.util.string.CompactString;
import org.rdfhdt.hdt.util.string.DelayedString;
import org.rdfhdt.hdt.util.string.ReplazableString;

public class ByteStringUtil {
    public static final Charset STRING_ENCODING = Charset.forName("UTF-8");

    private ByteStringUtil() {
    }

    public static final String asString(byte[] buff, int offset) {
        int len = ByteStringUtil.strlen(buff, offset);
        return new String(buff, offset, len, STRING_ENCODING);
    }

    public static final String asString(ByteBuffer buff, int offset) {
        int len = ByteStringUtil.strlen(buff, offset);
        byte[] arr = new byte[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = buff.get(offset + i);
        }
        return new String(arr, STRING_ENCODING);
    }

    public static final int strlen(byte[] buff, int off) {
        int pos;
        int len = buff.length;
        for (pos = off; pos < len && buff[pos] != 0; ++pos) {
        }
        return pos - off;
    }

    public static final int strlen(ByteBuffer buf, int base) {
        int n = buf.capacity() - base;
        for (int len = 0; len < n; ++len) {
            if (buf.get(base + len) != 0) continue;
            return len;
        }
        throw new IllegalArgumentException("Buffer not Null-Terminated");
    }

    public static final int longestCommonPrefix(CharSequence str1, CharSequence str2) {
        return ByteStringUtil.longestCommonPrefix(str1, str2, 0);
    }

    public static final int longestCommonPrefix(CharSequence str1, CharSequence str2, int from) {
        int delta;
        int len = Math.min(str1.length(), str2.length());
        for (delta = from; delta < len && str1.charAt(delta) == str2.charAt(delta); ++delta) {
        }
        return delta - from;
    }

    public static final int strcmp(CharSequence str2, byte[] buff2, int off2) {
        int len1;
        int off1;
        byte[] buff1;
        int len2 = buff2.length;
        if (str2 instanceof CompactString) {
            buff1 = ((CompactString)str2).getData();
            off1 = 0;
            len1 = buff1.length;
        } else if (str2 instanceof String) {
            buff1 = ((String)str2).getBytes(STRING_ENCODING);
            off1 = 0;
            len1 = buff1.length;
        } else if (str2 instanceof ReplazableString) {
            buff1 = ((ReplazableString)str2).buffer;
            off1 = 0;
            len1 = ((ReplazableString)str2).used;
        } else {
            throw new NotImplementedException();
        }
        int n = Math.min(len1 - off1, len2 - off2);
        int p1 = off1;
        int p2 = off2;
        while (n-- != 0) {
            int b;
            int a;
            if ((a = buff1[p1++] & 0xFF) != (b = buff2[p2++] & 0xFF)) {
                return a - b;
            }
            if (a != 0) continue;
            if (b == 0) {
                return 0;
            }
            return -1;
        }
        if (p1 - off1 < len1 && buff1[p1] != 0) {
            return 1;
        }
        if (p2 - off2 < len2 && buff2[p2] != 0) {
            return -1;
        }
        return 0;
    }

    public static final int strcmp(CharSequence str2, ByteBuffer buffer, int offset) {
        int i;
        int len;
        byte[] buf = null;
        if (str2 instanceof DelayedString) {
            str2 = ((DelayedString)str2).getInternal();
        }
        if (str2 instanceof CompactString) {
            buf = ((CompactString)str2).getData();
            len = buf.length;
        } else if (str2 instanceof String) {
            buf = ((String)str2).getBytes(STRING_ENCODING);
            len = buf.length;
        } else if (str2 instanceof ReplazableString) {
            buf = ((ReplazableString)str2).buffer;
            len = ((ReplazableString)str2).used;
        } else {
            throw new NotImplementedException();
        }
        int n = Math.min(len, buffer.capacity() - offset);
        for (i = 0; i < n; ++i) {
            int v1 = buf[i] & 0xFF;
            int v2 = buffer.get(offset + i) & 0xFF;
            if (v1 != v2) {
                return v1 - v2;
            }
            if (v1 != 0) continue;
            return 0;
        }
        if (buffer.capacity() - offset - i > 0) {
            byte v = buffer.get(offset + i);
            if (v == 0) {
                return 0;
            }
            return -1;
        }
        throw new IllegalArgumentException("Buffer is not Null-Terminated");
    }

    public static final int append(CharSequence str2, int start, byte[] buffer, int bufpos) {
        int len;
        byte[] bytes;
        if (str2 instanceof String) {
            bytes = ((String)str2).getBytes(STRING_ENCODING);
            len = bytes.length;
        } else if (str2 instanceof CompactString) {
            bytes = ((CompactString)str2).getData();
            len = bytes.length;
        } else if (str2 instanceof ReplazableString) {
            bytes = ((ReplazableString)str2).getBuffer();
            len = ((ReplazableString)str2).used;
        } else {
            throw new NotImplementedException();
        }
        int ini = start;
        int written = 0;
        for (int cur = start; cur < len; ++cur) {
            if (bytes[cur] != 0) continue;
            System.arraycopy(bytes, ini, buffer, bufpos + written, cur - ini);
            written += cur - ini;
            ini = cur + 1;
        }
        if (ini < len) {
            System.arraycopy(bytes, ini, buffer, bufpos + written, len - ini);
            written += len - ini;
        }
        return written;
    }

    public static final int append(OutputStream out, CharSequence str2, int start) throws IOException {
        int len;
        byte[] bytes;
        if (str2 instanceof String) {
            bytes = ((String)str2).getBytes(STRING_ENCODING);
            len = bytes.length;
        } else if (str2 instanceof CompactString) {
            bytes = ((CompactString)str2).getData();
            len = bytes.length;
        } else if (str2 instanceof ReplazableString) {
            bytes = ((ReplazableString)str2).getBuffer();
            len = ((ReplazableString)str2).used;
        } else {
            throw new NotImplementedException();
        }
        int ini = start;
        int written = 0;
        for (int cur = start; cur < len; ++cur) {
            if (bytes[cur] != 0) continue;
            out.write(bytes, ini, cur - ini);
            written += cur - ini;
            ini = cur + 1;
        }
        if (ini < len) {
            out.write(bytes, ini, len - ini);
            written += len - ini;
        }
        return written;
    }
}

