/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.string;

import java.util.Comparator;
import org.rdfhdt.hdt.util.string.CompactString;
import org.rdfhdt.hdt.util.string.DelayedString;
import org.rdfhdt.hdt.util.string.ReplazableString;

public final class CharSequenceComparator
implements Comparator<CharSequence> {
    private static final Comparator<CharSequence> instance = new CharSequenceComparator();

    public static Comparator<CharSequence> getInstance() {
        return instance;
    }

    @Override
    public int compare(CharSequence s1, CharSequence s2) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 instanceof DelayedString) {
            s1 = ((DelayedString)s1).str;
        }
        if (s2 instanceof DelayedString) {
            s2 = ((DelayedString)s2).str;
        }
        if (s1 instanceof CompactString && s2 instanceof CompactString) {
            CompactString cs1 = (CompactString)s1;
            CompactString cs2 = (CompactString)s2;
            return cs1.compareTo(cs2);
        }
        if (s1 instanceof String && s2 instanceof String) {
            String rs1 = (String)s1;
            String rs2 = (String)s2;
            return rs1.compareTo(rs2);
        }
        if (s1 instanceof ReplazableString && s2 instanceof ReplazableString) {
            ReplazableString cs1 = (ReplazableString)s1;
            ReplazableString cs2 = (ReplazableString)s2;
            return cs1.compareTo(cs2);
        }
        return s1.toString().compareTo(s2.toString());
    }
}

