/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.graph.Node;
import org.rdfhdt.hdtjena.cache.DictionaryCache;

public class DictionaryCacheLRI
implements DictionaryCache {
    private Map<Integer, Node> cache;
    private int[] arr;
    private int ptr;
    private final int size;

    public DictionaryCacheLRI(int size) {
        this.size = size;
        this.arr = new int[size];
        this.cache = new ConcurrentHashMap<Integer, Node>(size);
    }

    @Override
    public Node get(int id) {
        return this.cache.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(int id, Node node) {
        this.cache.put(id, node);
        if (this.cache.size() > this.size) {
            this.cache.remove(this.arr[this.ptr]);
        }
        DictionaryCacheLRI dictionaryCacheLRI = this;
        synchronized (dictionaryCacheLRI) {
            this.arr[this.ptr] = id;
            this.ptr = (this.ptr + 1) % this.size;
        }
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public void clear() {
        this.cache.clear();
    }
}

